// MouseSelectView.cpp : implementation of the CMouseSelectView class
//

#include "stdafx.h"
#include "MouseSelect.h"

#include "MouseSelectDoc.h"
#include "MouseSelectView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMouseSelectView

IMPLEMENT_DYNCREATE(CMouseSelectView, CView)

BEGIN_MESSAGE_MAP(CMouseSelectView, CView)
	//{{AFX_MSG_MAP(CMouseSelectView)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMouseSelectView construction/destruction

CMouseSelectView::CMouseSelectView()
{
	// TODO: add construction code here
	TestDraw=FALSE;
}

CMouseSelectView::~CMouseSelectView()
{
}

BOOL CMouseSelectView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMouseSelectView drawing

void CMouseSelectView::OnDraw(CDC* pDC)
{
	CMouseSelectDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CMouseSelectView printing

BOOL CMouseSelectView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMouseSelectView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMouseSelectView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMouseSelectView diagnostics

#ifdef _DEBUG
void CMouseSelectView::AssertValid() const
{
	CView::AssertValid();
}

void CMouseSelectView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMouseSelectDoc* CMouseSelectView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMouseSelectDoc)));
	return (CMouseSelectDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMouseSelectView message handlers

void CMouseSelectView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	TestDraw=FALSE;
	ReleaseCapture();
	CView::OnLButtonUp(nFlags, point);
}

void CMouseSelectView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	TestDraw=TRUE;
	DrawLine();
	MouseRect.left=point.x;
	MouseRect.top=point.y; 
	MouseRect.right =point.x;
	MouseRect.bottom =point.y; 
    SetCapture();
	CView::OnLButtonDown(nFlags, point);
}

void CMouseSelectView::DrawLine()
{
 CClientDC dc(this);
 int oldMode=dc.SetROP2(R2_NOT); 
 CBrush* oldBrush=(CBrush*)dc.SelectStockObject(NULL_BRUSH); 
 CPen* oldPen = (CPen*) dc.SelectStockObject(BLACK_PEN);
 dc.Rectangle(MouseRect); 
 dc.SelectObject(oldBrush); 
 dc.SelectObject(oldPen); 
 dc.SetROP2(oldMode); 
}

void CMouseSelectView::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (TestDraw)
	{
	DrawLine();
	MouseRect.right=point.x; 
	MouseRect.bottom = point.y; 	
	DrawLine();
	CView::OnMouseMove(nFlags, point);
	}
}
