// WordTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WordTest.h"
#include "WordTestDlg.h"
#include "msword9.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef enum {
	wdMove = 0,
	wdExtend = 1
} WdMovementType;


typedef enum {
		wdWord8TableBehavior = 0,
        wdWord9TableBehavior = 1
} WdDefaultTableBehavior;

typedef enum {
		wdAutoFitFixed = 0,
        wdAutoFitContent = 1,
        wdAutoFitWindow = 2
} WdAutoFitBehavior;

typedef enum {
	wdBorderTop = -1,
    wdBorderLeft = -2,
    wdBorderBottom = -3,
    wdBorderRight = -4,
    wdBorderHorizontal = -5,
    wdBorderVertical = -6,
    wdBorderDiagonalDown = -7,
    wdBorderDiagonalUp = -8
} WdBorderType;

typedef enum {
	wdLineStyleNone = 0,
    wdLineStyleSingle = 1,
    wdLineStyleDot = 2,
    wdLineStyleDashSmallGap = 3,
    wdLineStyleDashLargeGap = 4,
    wdLineStyleDashDot = 5,
    wdLineStyleDashDotDot = 6,
    wdLineStyleDouble = 7,
    wdLineStyleTriple = 8,
    wdLineStyleThinThickSmallGap = 9,
    wdLineStyleThickThinSmallGap = 10,
    wdLineStyleThinThickThinSmallGap = 11,
    wdLineStyleThinThickMedGap = 12,
    wdLineStyleThickThinMedGap = 13,
    wdLineStyleThinThickThinMedGap = 14,
    wdLineStyleThinThickLargeGap = 15,
    wdLineStyleThickThinLargeGap = 16,
    wdLineStyleThinThickThinLargeGap = 17,
    wdLineStyleSingleWavy = 18,
    wdLineStyleDoubleWavy = 19,
    wdLineStyleDashDotStroked = 20,
    wdLineStyleEmboss3D = 21,
    wdLineStyleEngrave3D = 22,
    wdLineStyleOutset = 23,
    wdLineStyleInset = 24
} WdLineStyle;

typedef enum {
	wdUnderlineNone = 0,
    wdUnderlineSingle = 1,
    wdUnderlineWords = 2,
    wdUnderlineDouble = 3,
    wdUnderlineDotted = 4,
    wdUnderlineThick = 6,
    wdUnderlineDash = 7,
    wdUnderlineDotDash = 9,
    wdUnderlineDotDotDash = 10,
    wdUnderlineWavy = 11,
    wdUnderlineWavyHeavy = 27,
    wdUnderlineDottedHeavy = 20,
    wdUnderlineDashHeavy = 23,
    wdUnderlineDotDashHeavy = 25,
    wdUnderlineDotDotDashHeavy = 26,
    wdUnderlineDashLong = 39,
    wdUnderlineDashLongHeavy = 55,
    wdUnderlineWavyDouble = 43
} WdUnderline;


typedef enum {
	wdCharacter = 1,
    wdWord = 2,
    wdSentence = 3,
    wdParagraph = 4,
    wdLine = 5,
    wdStory = 6,
    wdScreen = 7,
    wdSection = 8,
    wdColumn = 9,
    wdRow = 10,
    wdWindow = 11,
    wdCell = 12,
    wdCharacterFormatting = 13,
    wdParagraphFormatting = 14,
    wdTable = 15,
    wdItem = 16
} WdUnits;

typedef enum {
	wdTableFormatNone = 0,
    wdTableFormatSimple1 = 1,
    wdTableFormatSimple2 = 2,
    wdTableFormatSimple3 = 3,
    wdTableFormatClassic1 = 4,
    wdTableFormatClassic2 = 5,
    wdTableFormatClassic3 = 6,
    wdTableFormatClassic4 = 7,
    wdTableFormatColorful1 = 8,
    wdTableFormatColorful2 = 9,
    wdTableFormatColorful3 = 10,
    wdTableFormatColumns1 = 11,
    wdTableFormatColumns2 = 12,
    wdTableFormatColumns3 = 13,
    wdTableFormatColumns4 = 14,
    wdTableFormatColumns5 = 15,
    wdTableFormatGrid1 = 16,
    wdTableFormatGrid2 = 17,
    wdTableFormatGrid3 = 18,
    wdTableFormatGrid4 = 19,
    wdTableFormatGrid5 = 20,
    wdTableFormatGrid6 = 21,
    wdTableFormatGrid7 = 22,
    wdTableFormatGrid8 = 23,
    wdTableFormatList1 = 24,
    wdTableFormatList2 = 25,
    wdTableFormatList3 = 26,
    wdTableFormatList4 = 27,
    wdTableFormatList5 = 28,
    wdTableFormatList6 = 29,
    wdTableFormatList7 = 30,
    wdTableFormatList8 = 31,
    wdTableFormat3DEffects1 = 32,
    wdTableFormat3DEffects2 = 33,
    wdTableFormat3DEffects3 = 34,
    wdTableFormatContemporary = 35,
    wdTableFormatElegant = 36,
    wdTableFormatProfessional = 37,
    wdTableFormatSubtle1 = 38,
    wdTableFormatSubtle2 = 39,
    wdTableFormatWeb1 = 40,
    wdTableFormatWeb2 = 41,
    wdTableFormatWeb3 = 42
} WdTableFormat;

typedef enum {
	wdUndefined = 9999999,
	wdToggle = 9999998,
	wdForward = 1073741823,
	wdBackward = -1073741823,
	wdAutoPosition = 0,
	wdFirst = 1,
	wdCreatorCode = 1297307460
} WdConstants;

typedef enum {
	wdAlignParagraphLeft = 0,
    wdAlignParagraphCenter = 1,
    wdAlignParagraphRight = 2,
    wdAlignParagraphJustify = 3,
    wdAlignParagraphDistribute = 4,
    wdAlignParagraphJustifyMed = 5,
    wdAlignParagraphJustifyHi = 7,
    wdAlignParagraphJustifyLow = 8
} WdParagraphAlignment;

typedef enum {
	wdSectionBreakNextPage = 2,
    wdSectionBreakContinuous = 3,
    wdSectionBreakEvenPage = 4,
    wdSectionBreakOddPage = 5,
    wdLineBreak = 6,
    wdPageBreak = 7,
    wdColumnBreak = 8,
    wdLineBreakClearLeft = 9,
    wdLineBreakClearRight = 10,
    wdTextWrappingBreak = 11
} WdBreakType;
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWordTestDlg dialog

CWordTestDlg::CWordTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWordTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWordTestDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWordTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWordTestDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWordTestDlg, CDialog)
	//{{AFX_MSG_MAP(CWordTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTONREPORT, OnButtonreport)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWordTestDlg message handlers

BOOL CWordTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWordTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWordTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWordTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWordTestDlg::OnButtonreport() 
{

	_Application app;  // app -   _Application, .. Word 9 
	
	if(!app.CreateDispatch("Word.Application")) // 
	{
		AfxMessageBox("   !");
		return;
	}
	else
	{
		app.SetVisible(TRUE); //   	
	}


	Documents oDocs;
	_Document oDoc;
	COleVariant  covOptional((long)DISP_E_PARAMNOTFOUND, VT_ERROR);
	COleVariant covTrue((short)TRUE), covFalse((short)FALSE);

	//  
	oDocs = app.GetDocuments();
	//        
	//!    Word 97 -    :
	//oDocs.Add(covOptional,covOptional);
	oDocs.Add(covOptional,covOptional,covOptional,covOptional);	

	//        1
	oDoc = oDocs.Item(COleVariant(long(1)));
	// 
	oDoc.Activate(); 
	
	Paragraphs oPars;
	Paragraph oPar;	
	Selection oSel;

    // ---    ---
	
	// .   ,    
	oSel = app.GetSelection();	
	//   ,  .
	//  
	oPars = oSel.GetParagraphs();
	//      
	oPar = oPars.Add(covOptional);
	
	oSel.TypeText(" !\n");
	
	oPar.SetAlignment(wdAlignParagraphCenter);	
	oSel.TypeText("     \n");
	oPar.SetAlignment(wdAlignParagraphRight );	
	oSel.TypeText("      \n");
	oPar.SetAlignment(wdAlignParagraphLeft );	
	oSel.TypeText("      \n");
	oPar.SetAlignment(wdAlignParagraphJustify );	
	oSel.TypeText("      \n");
	
	//     Selection. 
	oSel.BoldRun();	
	oSel.TypeText("   \n");
	oSel.ItalicRun();
	oSel.TypeText("   \n");
	
	// 
	oSel.TypeParagraph();	

// -----------------------------------------------------------------------
//          	
//      
/*	///---    ---

	InlineShapes oShps;
	InlineShape oShp;
	
	oShps = oSel.GetInlineShapes();
	//        !!!
	//  Word        
	Shp = oShps.AddPicture("c:\\winnt\\winnt.bmp",covFalse,covTrue,covOptional);
	
	float width = oShp.GetWidth();
	float height = oShp.GetHeight();
	oShp.SetWidth(width*1.5);
	oShp.SetHeight(height*1.5);
*/
// -----------------------------------------------------------------------

	_Font fnt; fnt=oSel.GetFont(); //    
		//     Font (). 
	fnt.SetBold(1);						//  	
	fnt.SetUnderline(wdUnderlineSingle);// 	
	fnt.SetItalic(1);					// 	
	fnt.SetName("Arial");				// Arial
	fnt.SetSize(24);					//  24
	oSel.TypeText("     Arial,  24, ,   ");
	//      ( )
	oSel.MoveDown(COleVariant(short(wdParagraph)),COleVariant(long(wdForward)),COleVariant(short(wdMove)));
	//  
	oPar = oPars.Add(covOptional);

	// ---   ---
    _Document oActiveDoc; 
    oActiveDoc = app.GetActiveDocument();
    oActiveDoc.SaveAs(COleVariant("c:\\doc1.doc"), 
                    COleVariant((short)0),
                    covFalse, COleVariant(""), covTrue, COleVariant(""),
                    covFalse, covFalse, covFalse, covFalse, covFalse);
	
	
	// ---  ---


	//  c  
	Tables oTables;
	Table oTable;
	Range oRan;
	oRan = oPar.GetRange();

	oTables = oDoc.GetTables();
	oTable = oTables.Add(oRan,20,3,COleVariant((short)wdWord9TableBehavior), 
		COleVariant((short)wdAutoFitFixed));

    Cell oCell;

	oCell = oTable.Cell(5,2);
	oRan = oCell.GetRange();
	oRan.SetText(" 5,2");
	
	//  c 
	Borders oBorders;
	Border oBorder;
	oBorders = oCell.GetBorders();	 
	oBorder = oBorders.Item(wdBorderBottom);
	oBorder.SetVisible(FALSE); 
	oBorder = oBorders.Item(wdBorderRight);
	oBorder.SetVisible(FALSE); 
	oBorder = oBorders.Item(wdBorderTop);
	oBorder.SetLineStyle(wdLineStyleTriple); 
	
	oCell = oTable.Cell(1,1);
	oBorders = oCell.GetBorders();
	oBorders.SetEnable(wdLineStyleDoubleWavy); 
	
	//  
	oCell = oTable.Cell(1,2);
	Cell oSecondCell = oTable.Cell(1,3);
	oCell.Merge(oSecondCell);
	//  
	oCell = oTable.Cell(3,1);
	oCell.Split(COleVariant(short(2)),COleVariant(short(4)));
	
	// ---     ---

	oSel = app.GetSelection();
	//      ( )
	oSel.MoveDown(COleVariant(short(wdParagraph)),COleVariant(long(wdForward)),COleVariant(short(wdMove)));
	//  3 
	oSel.TypeText("\n\n\n");
	
	//  ,    ( )
	//     ( )
	CString sText;	
	for (int i=1; i<=10; i++)
	{
		sText.Format(" %d,1\t %d,2\t %d,3\n",i,i,i);
		oSel.TypeText(sText);
	}
	//     ,    
	oSel.MoveUp(COleVariant(short(wdParagraph)),COleVariant(long(10)),COleVariant(short(wdExtend)));
	//    
	oSel.ConvertToTable(
			COleVariant("\t"),		//   
			COleVariant((long)10),	// 10 
			COleVariant((long)3),	// 3 
			covOptional,
			COleVariant((long)wdTableFormatNone),//     
			covTrue,
			covTrue,
			covTrue,
			covTrue,
			covTrue,
			covTrue,
			covTrue,
			covTrue,
			covTrue,
			COleVariant((short)wdAutoFitContent), 
			COleVariant((short)wdWord9TableBehavior));

	//    ,  
	oSel.MoveDown(COleVariant(short(wdParagraph)),COleVariant(long(wdForward)),COleVariant(short(wdMove)));
}

BEGIN_EVENTSINK_MAP(CWordTestDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CWordTestDlg)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

