
#include "FactoryManager.h"

//    
//    Base  Derived
class Base
{
public:
	Base() {}
	virtual ~Base() {}
	virtual void Message()
	{
		cout << "Base::Message()" << endl;
	}
};

class Derived : public Base
{
public:
	Derived() {}
	virtual ~Derived() {}
	virtual void Message()
	{ 
		cout << "Derived::Message()" << endl;
		Private();
	};
private:
	void Private() 
	{
		cout << "Derived::Private()" << endl;
	}
};	


//    
class Foo
{
protected:
	void Protected()
	{
		cout << "Foo::Protected()" << endl;
	}

public:
	Foo() {}
	virtual ~Foo() {}
	virtual void Message()
	{
		cout << "Foo::Message()" << endl;
		Protected();
	}
};


//    
//     
class Bar
{
	//     
	friend class Factory<Bar>;
private:
	Bar() {}
protected:
	void Protected()
	{
		cout << "Bar::Protected()" << endl;
	}

public:
	virtual ~Bar() {}
	virtual void Message()
	{
		cout << "Bar::Message()" << endl;
		Protected();
	}
};






/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////



//   IUnknown    
//          
//     
//  -   public


#ifdef _DEBUG
#define PARANOID_VERSION 1
#endif

//    PARANOID_VERSION  
//   -  
//         Archive     


#ifdef PARANOID_VERSION
//             
//     - ""
//       RTTI

class IUnknown //      
{
public:
	IUnknown() {}
	virtual ~IUnknown() {}


	//    PARANOID_VERSION    
	//    
	//   virtual
	//   ,   - 


	//      virtual void Message() !!!
	void Message() //   
	{
		//          
		if(Foo *p = dynamic_cast <Foo *> (this)) 
			//     p->Message();  
			//          :
			Message(p); //  IUnknown::Message(Foo *p)



		//        

		//             
		else if(Derived *p = dynamic_cast <Derived *> (this)) 
			Message(p);

		//  
		else if(Base *p = dynamic_cast <Base *> (this)) 
			Message(p);

		//          
		else if(Bar *p = dynamic_cast <Bar *> (this)) 
			Message(p); //  IUnknown::Message(Bar *p)


		//        !!!!
		//     
		//  IUnknown *p = dynamic_cast <IUnknown *> (this)
		//    
		else if(IUnknown *p = dynamic_cast <IUnknown *> (this))
			Message(p);


		//         
		else //      
			cout << "so it is, but can't be so" << endl; //  
	}


	//          
	//             Message()
	//       ,    :-)
	void Message(Foo *p)
	{
		//   public  Message()
		//     ,    
		//     Foo
		cout << "IUnknown::Message(Foo *p)" << endl;
		p->Message();
	}

	void Message(IUnknown *p)
	{
		//         
		// FactoryManager<IUnknown>::m_DebugFactory

		cout << "IUnknown::Message(IUnknown *p)" << endl
			 << "IUnknown *p created by FactoryManager<IUnknown>::m_DebugFactory in action!" << endl;
		//  p.Message();    -      :-)
	}

	void Message(Derived *p)
	{
		cout << "IUnknown::Message(Derived *p)" << endl;
		p->Message();
	}
	void Message(Base *p)
	{
		cout << "IUnknown::Message(Base *p)" << endl;
		p->Message();
	}

	void Message(Bar *p)
	{
		cout << "IUnknown::Message(Bar *p)" << endl;
		p->Message();
	}

};







#else

//     !!!!!!!!!
//       !!!!!
//  RTTI   
class IUnknown 
{
public:
	IUnknown() {}
	virtual ~IUnknown() {}

	//   IUnknown::Message()  !!!!!
	//  -      
	//  IUnknown *pUnk  main'        !!!!!!
	virtual void Message()
	{
	}

	virtual void AnyOtherFunctionWeWantToStubify(int, double, std::string)
	{
	}
};


#endif


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


int main(int argc, char* argv[])
{
	FactoryManager< IUnknown > Fm; // FactoryManager  
	

	
	// Fm.AddFactory("IUnknown", new Factory<IUnknown> ); //     ,            


	//     
	// Fm.AddFactory(typeid(Derived).name(), new Factory<Derived> ); 
	//         
	//       <typeinfo>,   RTTI,   
   
	Fm.AddFactory("Derived", new Factory<Derived> );
	Fm.AddFactory("Foo", new Factory<Foo> );
	Fm.AddFactory("Base", new Factory<Base> );
	Fm.AddFactory("Bar", new Factory<Bar> );
	
	
	IUnknown *pUnk = NULL;
	
	//     pUnk-  
	//   
	//   !!!!!
	//    IUnknown   
	//     

	pUnk = Fm.Make("Bar");
	pUnk->Message();
	delete pUnk;

	pUnk = Fm.Make("Derived");
	pUnk->Message();
	delete pUnk;

	pUnk = Fm.Make("Foo");
	pUnk->Message();
	delete pUnk;

	pUnk = Fm.Make("Base");
	pUnk->Message();
	delete pUnk;

	pUnk = Fm.Make("Error"); //  ,    ( ?)  
	pUnk->Message();
	delete pUnk;


	getchar(); //   ,        
	
	return 0;
}


