// GradientDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Gradient.h"
#include "GradientDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGradientDlg dialog

CGradientDlg::CGradientDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGradientDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGradientDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGradientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGradientDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGradientDlg, CDialog)
	//{{AFX_MSG_MAP(CGradientDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGradientDlg message handlers

BOOL CGradientDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGradientDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this); // device context for painting
		CRect rect;
		GetClientRect(rect);
		GradientFillRect(dc.GetSafeHdc(),rect,RGB(255,0,0),RGB(0,0,255),128);
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGradientDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CGradientDlg::GradientFillRect(HDC pDC, CRect ARect, COLORREF StartColor,COLORREF EndColor, int Colors)
{
//    
if (ARect.IsRectEmpty()) return;

HBRUSH Brush;

// -         
if (Colors < 2) 
{
    Brush = CreateSolidBrush(StartColor);
    FillRect(pDC, ARect, Brush);
    DeleteObject(Brush);
    return;
}

BYTE StartRGB[3];
int RGBDelta[3];
CRect ColorBand;
int I,Delta;

//  
StartRGB[0] = GetRValue(StartColor);
StartRGB[1] = GetGValue(StartColor);
StartRGB[2] = GetBValue(StartColor);
//  
RGBDelta[0] = GetRValue(EndColor) - StartRGB[0];
RGBDelta[1] = GetGValue(EndColor) - StartRGB[1];
RGBDelta[2] = GetBValue(EndColor) - StartRGB[2];

ColorBand = ARect;
Colors = max(2, min(Colors, ARect.Height()));
Delta = (int)(ARect.Height() / Colors);

//   
if (Delta>0)
 for (I=0;I<Colors;I++)
 {
	  ColorBand.top = ARect.top + I * Delta;
      ColorBand.bottom = ColorBand.top + Delta;
      Brush = CreateSolidBrush(RGB(
                               StartRGB[0] + MulDiv(I, RGBDelta[0], Colors - 1),
                               StartRGB[1] + MulDiv(I, RGBDelta[1], Colors - 1),
                               StartRGB[2] + MulDiv(I, RGBDelta[2], Colors - 1)));
      FillRect(pDC, ColorBand, Brush);
      DeleteObject(Brush);
 }

//   
div_t Res;
Res=div(ARect.Height() , Colors);
Delta =Res.rem;//  
if (Delta>0)
 for (I=0;I<Colors;I++)
 {
      ColorBand.top = ARect.bottom - Delta;
      ColorBand.bottom = ColorBand.top + Delta;
      Brush = CreateSolidBrush(EndColor);
      FillRect(pDC, ColorBand, Brush);
      DeleteObject(Brush);
 }


}


void CGradientDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	//   
    Invalidate();	
}
