// CntrItem.cpp : implementation of the CTestOleContCntrItem class
//

#include "stdafx.h"
#include "TestOleCont.h"

#include "TestOleContDoc.h"
#include "TestOleContView.h"
#include "CntrItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTestOleContCntrItem implementation

IMPLEMENT_SERIAL(CTestOleContCntrItem, COleClientItem, 0)

CTestOleContCntrItem::CTestOleContCntrItem(CTestOleContDoc* pContainer)
	: COleClientItem(pContainer)
{
	m_Rect=CRect(10,10,210,210);
}

CTestOleContCntrItem::~CTestOleContCntrItem()
{
	// TODO: add cleanup code here
	
}

void CTestOleContCntrItem::OnChange(OLE_NOTIFICATION nCode, DWORD dwParam)
{
	ASSERT_VALID(this);

	COleClientItem::OnChange(nCode, dwParam);

	// When an item is being edited (either in-place or fully open)
	//  it sends OnChange notifications for changes in the state of the
	//  item or visual appearance of its content.

	// TODO: invalidate the item by calling UpdateAllViews
	//  (with hints appropriate to your application)

	GetDocument()->UpdateAllViews(NULL);
		// for now just update ALL views/no hints
}

BOOL CTestOleContCntrItem::OnChangeItemPosition(const CRect& rectPos)
{
	ASSERT_VALID(this);
    m_Rect=rectPos;
	GetDocument()->SetModifiedFlag();
	GetDocument()->UpdateAllViews(NULL); 
	
	if (!COleClientItem::OnChangeItemPosition(rectPos))
		return FALSE;

	// TODO: update any cache you may have of the item's rectangle/extent

	return TRUE;
}

void CTestOleContCntrItem::OnGetItemPosition(CRect& rPosition)
{
	ASSERT_VALID(this);
	rPosition = m_Rect;
}

void CTestOleContCntrItem::OnActivate()
{
    // Allow only one inplace activate item per frame
    CTestOleContView* pView = GetActiveView();
    ASSERT_VALID(pView);
    COleClientItem* pItem = GetDocument()->GetInPlaceActiveItem(pView);
    if (pItem != NULL && pItem != this)
        pItem->Close();
    
    COleClientItem::OnActivate();
}

void CTestOleContCntrItem::OnDeactivateUI(BOOL bUndoable)
{
	COleClientItem::OnDeactivateUI(bUndoable);

    // Hide the object if it is not an outside-in object
    DWORD dwMisc = 0;
    m_lpObject->GetMiscStatus(GetDrawAspect(), &dwMisc);
    if (dwMisc & OLEMISC_INSIDEOUT)
        DoVerb(OLEIVERB_HIDE, NULL);
}

void CTestOleContCntrItem::Serialize(CArchive& ar)
{
	ASSERT_VALID(this);

	// Call base class first to read in COleClientItem data.
	// Since this sets up the m_pDocument pointer returned from
	//  CTestOleContCntrItem::GetDocument, it is a good idea to call
	//  the base class Serialize first.
	COleClientItem::Serialize(ar);

	// now store/retrieve data specific to CTestOleContCntrItem
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTestOleContCntrItem diagnostics

#ifdef _DEBUG
void CTestOleContCntrItem::AssertValid() const
{
	COleClientItem::AssertValid();
}

void CTestOleContCntrItem::Dump(CDumpContext& dc) const
{
	COleClientItem::Dump(dc);
}
#endif

/////////////////////////////////////////////////////////////////////////////
