// SeverWinSock.cpp: implementation of the CSeverWinSock class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SeverWinSock.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSeverWinSock::CSeverWinSock()
{

}

CSeverWinSock::~CSeverWinSock()
{

}

BOOL CSeverWinSock::StartServer(HWND m_hWnd)
{
	if (!StartWinSock()) return FALSE;
    if (!SocketGetHostName()) return FALSE;
	if (!CreateSocket()) return FALSE;
	if (!LinkSoketPort()) return FALSE;
    if (!LinkWindowSocket(m_hWnd)) return FALSE;
	if (!ListenSocket()) return FALSE;
	return TRUE;
}


BOOL StopWinSock()
{
	if (WSACleanup()) 
	{
		AfxMessageBox("Error Cleapir\n");
		return FALSE;
    }
	else return TRUE;
}

void CSeverWinSock::StopServer()
{
 StopWinSock();
 CloseScoket();
}


BOOL CSeverWinSock::LinkSoketPort()
{

	SOCKADDR_IN socketaddr;
	socketaddr.sin_family = AF_INET;
	socketaddr.sin_addr.s_addr  = INADDR_ANY; 
	socketaddr.sin_port = htons(PORT_ADDR);

	if (bind(servsocket,(LPSOCKADDR)&socketaddr,sizeof(socketaddr)) == SOCKET_ERROR)
	{
		AfxMessageBox("Error bind socket");
		return FALSE;
	}
	else return TRUE;
}

BOOL CSeverWinSock::StopWinSock()
{
	if (WSACleanup())
	{
		AfxMessageBox("Error Cleapir");
		return FALSE;
	}
	else return TRUE;
}

void CSeverWinSock::CloseScoket()
{
	closesocket(servsocket);
}

BOOL CSeverWinSock::ListenSocket()
{
	int Errors;
	Errors=listen(servsocket,QUEUE_SIZE);
	if ( Errors == SOCKET_ERROR)
	{
		AfxMessageBox(" Listen BAD !!! ");
		return FALSE;
	}
	else return TRUE;
}

BOOL CSeverWinSock::LinkWindowSocket(HWND m_hWnd)
{
	int Errors;
	Errors=WSAAsyncSelect(servsocket,m_hWnd,WM_SERVER_ACCEPT, FD_ACCEPT);
	if (Errors == SOCKET_ERROR)
	{
		AfxMessageBox(" AsyncSelect BAD !!! ");
		return FALSE;
	}
	else return TRUE;
}


BOOL CSeverWinSock::CreateSocket()
{
	servsocket = socket(PF_INET,SOCK_STREAM,DEFAULT_PROTOCOL);
	if (servsocket==INVALID_SOCKET) 
	{
		AfxMessageBox("Error create socket");
		return FALSE;
	}
	return TRUE;
}

BOOL CSeverWinSock::SocketGetHostName()
{
	char chInfo[64];

	if (gethostname(chInfo,sizeof(chInfo)))
	{
		AfxMessageBox("Not local host");
		return FALSE;
	}
	else return TRUE;
}

BOOL CSeverWinSock::StartWinSock()
{
	WSADATA wsaData;
	if (WSAStartup(WINSOCK_VERSION, &wsaData)) 
	{
		AfxMessageBox("winsock not bi initialized !");
		WSACleanup();
		return FALSE;
	}
	else return TRUE;
}