// HTTPServerView.cpp : implementation of the CHTTPServerView class
//

#include "stdafx.h"
#include "HTTPServer.h"

#include "HTTPServerDoc.h"
#include "HTTPServerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView

IMPLEMENT_DYNCREATE(CHTTPServerView, CView)

BEGIN_MESSAGE_MAP(CHTTPServerView, CView)
	//{{AFX_MSG_MAP(CHTTPServerView)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SERVER_ACCEPT,OnServerAccept)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView construction/destruction

CHTTPServerView::CHTTPServerView()
{
	blTestStartServer=FALSE;
}

CHTTPServerView::~CHTTPServerView()
{
}

BOOL CHTTPServerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView drawing

void CHTTPServerView::OnDraw(CDC* pDC)
{
	CHTTPServerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	
	pDC->TextOut(10,10,pDoc->csInfo);  
}

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView diagnostics

#ifdef _DEBUG
void CHTTPServerView::AssertValid() const
{
	CView::AssertValid();
}

void CHTTPServerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CHTTPServerDoc* CHTTPServerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CHTTPServerDoc)));
	return (CHTTPServerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView message handlers

void CHTTPServerView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if (!blTestStartServer)
	{
	if (HTTPServer.StartServer(m_hWnd))
	{
		CHTTPServerDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pDoc->csInfo = "Server Start"; 
		Invalidate();
		blTestStartServer=TRUE;
	}
	}
	CView::OnLButtonDown(nFlags, point);
}

void CHTTPServerView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	
	HTTPServer.StopServer();
	CHTTPServerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->csInfo = "Server Stop"; 
	Invalidate();
	blTestStartServer=FALSE;
	CView::OnRButtonDown(nFlags, point);
}

afx_msg LRESULT CHTTPServerView::OnServerAccept(WPARAM wParam, LPARAM lParam)
{
	MessageBeep(-1);
	CHTTPServerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->csInfo = "Client Connect !!!!!"; 
	Invalidate();
	return 0L;
}
