// SeverWinSock.cpp: implementation of the CSeverWinSock class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SeverWinSock.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSeverWinSock::CSeverWinSock()
{
	TestLogFile=FALSE;
	cLogFile.csFileName=NAMEFILE;
	cLogFile.Create(); 
}

CSeverWinSock::~CSeverWinSock()
{

}

BOOL CSeverWinSock::StartServer(HWND m_hWnd)
{
	if (!StartWinSock()) return FALSE;
    if (!SocketGetHostName()) return FALSE;
	if (!CreateSocket()) return FALSE;
	if (!LinkSoketPort()) return FALSE;
    if (!LinkWindowSocket(m_hWnd)) return FALSE;
	if (!ListenSocket()) return FALSE;
	return TRUE;
}


BOOL CSeverWinSock::StopWinSock()
{
	if (WSACleanup()) 
	{
		LogsWrite("Error Cleapir");
	LogsWrite("StopWinSock");
		AfxMessageBox("Error Cleapir\n");
		return FALSE;
    }
	else return TRUE;
	LogsWrite("StopWinSock");
}

void CSeverWinSock::StopServer()
{
 LogsWrite("StopServer");
 StopWinSock();
 CloseScoket();
}


BOOL CSeverWinSock::LinkSoketPort()
{

	SOCKADDR_IN socketaddr;
	socketaddr.sin_family = AF_INET;
	socketaddr.sin_addr.s_addr  = INADDR_ANY;
	socketaddr.sin_port = htons(PORT_ADDR);

	if (bind(servsocket,(LPSOCKADDR)&socketaddr,sizeof(socketaddr)) == SOCKET_ERROR)
	{
		LogsWrite("Error bind socket");
		AfxMessageBox("Error bind socket");
		return FALSE;
	}
	LogsWrite("bind");
	return TRUE;
}


void CSeverWinSock::CloseScoket()
{
	closesocket(servsocket);
	LogsWrite("Close Socket");
}

BOOL CSeverWinSock::ListenSocket()
{
	int Errors;
	Errors=listen(servsocket,QUEUE_SIZE);
	if ( Errors == SOCKET_ERROR)
	{
		LogsWrite(" Listen BAD !!!");
		AfxMessageBox(" Listen BAD !!! ");
		return FALSE;
	}
	LogsWrite("Listen ");
    return TRUE;
}

BOOL CSeverWinSock::LinkWindowSocket(HWND m_hWnd)
{
	int Errors;
	Errors=WSAAsyncSelect(servsocket,m_hWnd,WM_SERVER_ACCEPT, FD_ACCEPT);
	if (Errors == SOCKET_ERROR)
	{
		LogsWrite("AsyncSelect BAD !!! ");
		AfxMessageBox(" AsyncSelect BAD !!! ");
		return FALSE;
	}
	LogsWrite("WSAAsyncSelect ");
    return TRUE;
}


BOOL CSeverWinSock::CreateSocket()
{
	servsocket = socket(PF_INET,SOCK_STREAM,DEFAULT_PROTOCOL);
	if (servsocket==INVALID_SOCKET) 
	{
		AfxMessageBox("Error create socket");
		LogsWrite("Error create socket");
		return FALSE;
	}
	LogsWrite(" ");
	CString  temp;
	temp.Format(" %i", PORT_ADDR);
	LogsWriteNotTime(" " + temp);
	LogsWriteNotTime("   ");
	return TRUE;
}

BOOL CSeverWinSock::SocketGetHostName()
{
	char chInfo[64];

	if (gethostname(chInfo,sizeof(chInfo)))
	{
		AfxMessageBox("Not local host");
		LogsWrite("Not local host");
		return FALSE;
	}
	LogsWriteNotTime("  ");
	LogsWrite(chInfo);
	return TRUE;
}

BOOL CSeverWinSock::StartWinSock()
{
	if (WSAStartup(WINSOCK_VERSION, &wsaData)) 
	{
		AfxMessageBox("winsock not bi initialized !");
		LogsWrite("winsock not bi initialized !");
		WSACleanup();
		return FALSE;
	} 
	LogsWrite(" WinSock");
	LogsWriteNotTime("  WinSock.DLL"); 
	LogsWriteNotTime(wsaData.szDescription); 
	LogsWriteNotTime(wsaData.szSystemStatus);
	return TRUE;
}

void CSeverWinSock::SendData(LPSTR buff)
{
int Errors;
Errors = send(clientsocket,(LPSTR)buff,lstrlen(buff),0);
if (Errors == SOCKET_ERROR) AfxMessageBox("Error Send");
}

void CSeverWinSock::LogsWrite(CString writeString)
{
 if (TestLogFile) 
 {
	 cLogFile.PrintTime(); 
	 cLogFile.write(writeString); 
 }
}

void CSeverWinSock::LogsWriteNotTime(CString writeString)
{
if (TestLogFile)  	 cLogFile.write(writeString); 
}
