// HTTPServerView.cpp : implementation of the CHTTPServerView class
//

#include "stdafx.h"
#include "HTTPServer.h"

#include "HTTPServerDoc.h"
#include "HTTPServerView.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#include "ToolsOptios.h"

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView

IMPLEMENT_DYNCREATE(CHTTPServerView, CView)

BEGIN_MESSAGE_MAP(CHTTPServerView, CView)
	//{{AFX_MSG_MAP(CHTTPServerView)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_TOOLS_OPTIONS, OnToolsOptions)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SERVER_ACCEPT,OnServerAccept)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView construction/destruction

CHTTPServerView::CHTTPServerView()
{
	blTestStartServer=FALSE;
}

CHTTPServerView::~CHTTPServerView()
{
}

BOOL CHTTPServerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView drawing

void CHTTPServerView::OnDraw(CDC* pDC)
{
	CHTTPServerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	
	pDC->TextOut(10,10,pDoc->csInfo);  
}

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView diagnostics

#ifdef _DEBUG
void CHTTPServerView::AssertValid() const
{
	CView::AssertValid();
}

void CHTTPServerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CHTTPServerDoc* CHTTPServerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CHTTPServerDoc)));
	return (CHTTPServerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CHTTPServerView message handlers

void CHTTPServerView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if (!blTestStartServer)
	{
	if (HTTPServer.StartServer(m_hWnd))
	{
		CHTTPServerDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pDoc->csInfo = "Server Start"; 
		Invalidate();
		blTestStartServer=TRUE;
	}
	}
	CView::OnLButtonDown(nFlags, point);
}

void CHTTPServerView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	
	HTTPServer.StopServer();
	CHTTPServerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->csInfo = "Server Stop"; 
	Invalidate();
	blTestStartServer=FALSE;
	CView::OnRButtonDown(nFlags, point);
}



afx_msg LRESULT CHTTPServerView::OnServerAccept(WPARAM wParam, LPARAM lParam)
{
	CHTTPServerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	HTTPServer.clientsocket = INVALID_SOCKET;
	pDoc->csInfo = "Client Connect !!!!!"; 
	Invalidate();
	if (WSAGETASYNCERROR(lParam))
	{
		AfxMessageBox("Error detecting Client");
		return 0L;
	}
	if (WSAGETSELECTEVENT(lParam) == FD_ACCEPT)
	{
		int length=sizeof(SOCKADDR);
	
		SOCKADDR_IN socketclientaddr;
		HTTPServer.clientsocket=accept(HTTPServer.servsocket,(LPSOCKADDR)&socketclientaddr, (LPINT) &length);
		if (HTTPServer.clientsocket == INVALID_SOCKET)
		{
			AfxMessageBox("Invalid Client Socket");
			return 0L;
		}
      CString buff="<html>\n<p>    \n</html>\r\n";
	  HTTPServer.SendData(buff.GetBuffer(1000));
	  closesocket(HTTPServer.clientsocket);
	   
	}

	return 0L;
}

void CHTTPServerView::OnToolsOptions() 
{
	CToolsOptios ctopt;
	ctopt.m_LogFile=HTTPServer.TestLogFile;
	if (ctopt.DoModal()==IDOK) 	HTTPServer.TestLogFile=ctopt.m_LogFile;
}
