// =====================================================
// Title					: Xyz - Zzlex NS LookUp simple client
// Description				: NS Query Packet Format Study.
// Author					: Alex Zzlex. Israel.
// E-mail					: mailto:zzlex@iname.com
// E-mail					: mailto:zzlex@mail.ru
// =====================================================
//
// XyzDlg.h : header file
//

#if !defined(AFX_XYZDLG_H__E10A01B6_3085_11D4_A710_0040332710D6__INCLUDED_)
#define AFX_XYZDLG_H__E10A01B6_3085_11D4_A710_0040332710D6__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
///////////////////////////////////////////////////////////
#define MAXDIRNAME	0x0100
#define MAXFILENAME	0x0100
#define MAXHOSTNAME	0x0100
#define MAXSOCKBUFF	0x8000
//
#define XNS_QUERY		0
#define XNS_RESPONSE	1
//
#define FROM_OBJECT_TO_SCREEN	FALSE
#define FROM_SCREEN_TO_OBJECT	TRUE
//
#define HEBBOOL	BOOL
#define KEN		TRUE
#define LO		FALSE
///////////////////////////////////////////////////////////
typedef SHORT SH_INT;
typedef USHORT SH_WORD;
typedef struct tagQFLAGS
{
SH_WORD xRCODE     :    4;		// ResponseCode 0) NoErrors
SH_WORD xZ         :    3;		// RFU
SH_WORD xRA        :    1;		// Recursion Available (fromNameServer)
SH_WORD xRD        :    1;		// Recursion Desired (byProgram)
SH_WORD xTC        :    1;		// TrunCation (fromNameServer)
SH_WORD xAA        :    1;		// Authoritative Answer (fromNameServer)
SH_WORD xOPCODE    :    4;		// 0)SQUERY,1)IQUERY,2)Server STATUS request.
SH_WORD xQR        :    1;		// 1 Bit 0)query,1)response.
} QFLAGS;
//
typedef struct tagRNSQ_HEADER
{
SH_WORD xID;					// 16 bits Identifier maded by program.
QFLAGS xf;						//
SH_WORD xQDCOUNT;				// No of entries in Question section
SH_WORD xANCOUNT;				// No of entries in Answer section
SH_WORD xNSCOUNT;				// No of entries in Authority section
SH_WORD xARCOUNT;				// No of entries in Addition section
} RNSQ_HEADER;
//
//
typedef struct tagRRFIELD
{
BYTE *xpbQueryBuf;				// Pointer to QueryBuffer (RecBuffer+2)
BOOL xboolRR;					// KEN - RR-field, LO - Question
DWORD xdwOfs;					// Offset in buffer DWORD
SH_WORD xwNAMEFIELDLEN;			// NAME field Length WORD
BYTE *xpbNAME;					// NAME Pointer
SH_WORD xwTYPE;					// NS_WORD TYPE WORD
SH_WORD xwCLASS;				// NS_WORD CLASS WORD
DWORD xdwTTL;					// NS_DWORD TTL DWORD
SH_WORD xwRDLENGTH;				// NS_WORD RDLENGTH WORD
BYTE *xpbRDATA;					// RDATA pointer (depend on TYPE)
} RRFIELD;
//
//
/////////////////////////////////////////////////////////////////////////////
// CXyzDlg dialog

class CXyzDlg : public CDialog
{
// Construction
public:
	CXyzDlg(CWnd* pParent = NULL);	// standard constructor
// =========================================
	BOOL fnLoadFont(void);
	INT fnReUse(SOCKET s);
    LONG fnMakeNsQuery(CHAR *zQName,SH_INT iQType);
	WORD fnGPort(CHAR *pPort,SERVENT &rService);
	WORD fnGHost(CHAR *pHost,SOCKADDR_IN &rSockAddrIn);
	LONG fnDecodeNsHeader(RNSQ_HEADER *prNsHeader, CHAR *zAns);
	LONG fnDecodeNsName(CHAR *pbNm, CHAR *zAnStr, CHAR *pbQu);
	LONG fnDecodeNsRrField(RRFIELD *prRr, CHAR *zAnStr);
	LONG fnDecodeNsResponse(BYTE *pbBuf, CHAR *zAnStr);
	LONG fnSaveQuOrRespBinByHostName(BOOL boolDaType, CHAR * pbBuf, WORD wLe);
	INT  fnGetQueryType(WORD wID);
	DWORD fn2OutModes(CHAR *pbFm, CHAR *pbTo, DWORD dwNbt, BOOL boolAsc);
	DWORD fnCountString(DWORD dwNbt, BOOL boolAsc);
// Dialog Data
	//{{AFX_DATA(CXyzDlg)
	enum { IDD = IDD_XYZ_DLG };
	CString	mEdHost;
	CString	mEdAnswer;
	CString	mEdNameServer;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CXyzDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL
	CHAR *zCurrentDir;
	SOCKET soS;
    CHAR *aBuf;
	CFont *pcf;
	CHAR *gzAnStr;
// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CXyzDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnBtnSend();
	afx_msg void OnBtnConnection();
	afx_msg void OnKillfocusEdHost();
	afx_msg void OnDestroy();
	afx_msg void OnKillfocusEdNameserver();
	afx_msg void OnBtnFmFile();
	afx_msg void OnBtnBin2Ascii();
	//}}AFX_MSG
	afx_msg void MnuBin2Ascii();
	afx_msg void MnuFmFile();
	afx_msg void MnuOpen();
	afx_msg void MnuSaveAs();
	afx_msg LONG fnOnNsSockMsg(SOCKET wFmSocket,LONG loEvent);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_XYZDLG_H__E10A01B6_3085_11D4_A710_0040332710D6__INCLUDED_)
