// =====================================================
// Title					: Xyz - Zzlex NS LookUp simple client
// Description				: NS Query Packet Format Study.
// Author					: Alex Zzlex. Israel.
// E-mail					: mailto:zzlex@iname.com
// E-mail					: mailto:zzlex@mail.ru
// =====================================================
//
// XyzDlg.cpp : implementation file
//
//
#include "stdafx.h"
#include "Xyz.h"
#include "XyzDlg.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
//
////////////////////////////////////////////////////////
// User's definitions, variables, constants, etc.
////////////////////////////////////////////////////////
#define SSSAVE	LO
#define SSOPEN	KEN
//
#define RTYPE_A		0x01
#define RTYPE_NS	0x02
#define RTYPE_MD	0x03
#define RTYPE_MF	0x04
#define RTYPE_CNAME	0x05
#define RTYPE_SOA	0x06
#define RTYPE_MB	0x07
#define RTYPE_MG	0x08
#define RTYPE_MR	0x09
#define RTYPE_NULL	0x0A
#define RTYPE_WKS	0x0B
#define RTYPE_PTR	0x0C
#define RTYPE_HINFO	0x0D
#define RTYPE_MINFO	0x0E
#define RTYPE_MX	0x0F
#define RTYPE_TXT	0x10
//
#define QCLASS_IN	1 // Type IN : INTERNET
// This is MACRO for comfortable using :)
#define mFnDecodeNsQuery	fnDecodeNsResponse
//
// Query/Response Types table (for RR-field handling)
const CHAR * const aNsRrType[0x10] = 
{
"A","NS","MD","MF","CNAME","SOA","MB","MG",
"MR","NULL","WKS","PTR","HINFO","MINFO","MX","TXT"
};
//
// Query Classes table (for RR-field handling)
const CHAR * const aNsRrClass[4] =
{
"IN","CS","CH","HS"
};
//
// BIN to ASCII recoding table
CHAR const tbXlat[0x10]=
{'0','1','2','3','4','5','6','7',
'8','9','A','B','C','D','E','F'};
//
// Global Variable for WindowsMessage Registering. (In 'Xyz.cpp' file)
extern INT giNsSockMsgId;
//
////////////////////////////////////////////////////////
// Wizard's implementations
////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

////////////////////////////////////////////////////////
// CXyzDlg dialog
////////////////////////////////////////////////////////
CXyzDlg::CXyzDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CXyzDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXyzDlg)
	mEdHost = _T("www.netvision.net.il");
	mEdAnswer = _T("");
	mEdNameServer = _T("dns.netvision.net.il");
	//}}AFX_DATA_INIT
// =================================
	gzAnStr = NULL;
	zCurrentDir = NULL;
	aBuf = NULL;
	pcf = NULL;
// =================================
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}
//
void CXyzDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXyzDlg)
	DDX_Text(pDX, IDC_ED_HOST, mEdHost);
	DDV_MaxChars(pDX, mEdHost, 80);
	DDX_Text(pDX, IDC_ED_ANSWER, mEdAnswer);
	DDV_MaxChars(pDX, mEdAnswer, 16000);
	DDX_Text(pDX, IDC_ED_NAMESERVER, mEdNameServer);
	//}}AFX_DATA_MAP
}
//
BEGIN_MESSAGE_MAP(CXyzDlg, CDialog)
	//{{AFX_MSG_MAP(CXyzDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_SEND, OnBtnSend)
	ON_BN_CLICKED(IDC_BTN_CONNECTION, OnBtnConnection)
	ON_EN_KILLFOCUS(IDC_ED_HOST, OnKillfocusEdHost)
	ON_WM_DESTROY()
	ON_EN_KILLFOCUS(IDC_ED_NAMESERVER, OnKillfocusEdNameserver)
	ON_BN_CLICKED(IDC_BTN_FMFILE, OnBtnFmFile)
	ON_BN_CLICKED(IDC_BTN_BIN2ASCII, OnBtnBin2Ascii)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_BIN2ASCII, MnuBin2Ascii)
	ON_COMMAND(ID_FM_FILE, MnuFmFile)
	ON_COMMAND(ID_OPEN, MnuOpen)
	ON_COMMAND(ID_SAVEAS, MnuSaveAs)
	ON_REGISTERED_MESSAGE(giNsSockMsgId, fnOnNsSockMsg)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXyzDlg message handlers
//
BOOL CXyzDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
// TODO: Add extra initialization here
gzAnStr = new CHAR [0x4000];
ASSERT(gzAnStr);
CComboBox *cb = NULL;
cb = (CComboBox *)GetDlgItem(IDC_CBOX_TYPES);
cb->SetCurSel(0);
zCurrentDir = new CHAR [MAXDIRNAME];
ASSERT(zCurrentDir);
if(!GetCurrentDirectory(MAXDIRNAME,zCurrentDir))
  AfxMessageBox("GetCurrentDirectory Error !!");
aBuf = new CHAR [MAXSOCKBUFF];
ASSERT(aBuf);
pcf = new CFont;
ASSERT(pcf);
fnLoadFont(); // Change Font to 'Courier New' (monospace, for alighnment)
// Before all You must call WSAStartup succeful.
if(!WSAStartup(MAKEWORD(1, 1),(WSADATA *)aBuf))
  {
  soS = socket(AF_INET, SOCK_STREAM, 0);
  ASSERT(soS);
  if(!fnReUse(soS))
    mEdAnswer = "Socket Created...\r\n";
  else
	AfxMessageBox("ReUse Function Error");
    if(WSAAsyncSelect(soS, m_hWnd,
       giNsSockMsgId,
       FD_READ | FD_CONNECT) == SOCKET_ERROR)
	{
	AfxMessageBox("WSAAsyncSelect ERROR !!!");
	closesocket(soS);
	} // End IF WSAAsyncSelect() NOT successful.
  } // End IF WSAStartup() successful.
else
  {
  mEdAnswer = "Create Socket function error !\r\n";
  }
UpdateData(FROM_OBJECT_TO_SCREEN);
return TRUE;  // return TRUE  unless you set the focus to a control
}
//
void CXyzDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}
//
// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
//
void CXyzDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}
//
// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CXyzDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CXyzDlg::OnDestroy() 
{
	CDialog::OnDestroy();
// TODO: Add your message handler code here
closesocket(soS);
WSACleanup();
if(gzAnStr)
  delete [] gzAnStr;
if(zCurrentDir)
  delete [] zCurrentDir;
if(aBuf)
  delete [] aBuf;
if(pcf)
  delete pcf;
}
//
////////////////////////////////////////////////////////
// Here begins my work
////////////////////////////////////////////////////////
// =====================================================
// Prepare Data and try to connect with server.
// Used with mask of WSAAsyncSelect() as 'non blocked'.
// =====================================================
void CXyzDlg::OnBtnConnection() 
{
// TODO: Add your control notification handler code here
SOCKADDR_IN rSockAddrIn;
SERVENT rService;
WORD wAA;
char zHost[MAXHOSTNAME];
//
zHost[0] = '\0';
strcpy((char *)(&zHost[0]), mEdNameServer);
wAA = fnGHost(zHost,rSockAddrIn); // Prepare HostStructure.
if(wAA)
  {
  wAA = fnGPort("53",rService); // Prepare ServiceStructure
    if(wAA)
	{
    rSockAddrIn.sin_family = AF_INET;
    rSockAddrIn.sin_port = wAA;
    mEdAnswer += "Begin connection\r\n";
    wAA = (WORD)connect(soS, (SOCKADDR *)&rSockAddrIn, sizeof(rSockAddrIn));
	} // Result of Connestion handled by function 'fnOnNsSockMsg()'.
  } // End if GetHost successful
else
  {
  AfxMessageBox("Prepare Host Error. Connect");
  }
}
// =====================================================
// Make QueryPacket by HostName and QueryType, send
// packet to NS server.
// Received Data will be handled in function 'fnOnNsSockMsg()'.
// =====================================================
void CXyzDlg::OnBtnSend() 
{
// TODO: Add your control notification handler code here
WORD wAA;
wAA = 0;
char zHost[MAXHOSTNAME];
zHost[0] = '\0';
*gzAnStr=0;
strcpy((char *)(&zHost[0]), mEdHost);
wAA = fnGetQueryType(IDC_CBOX_TYPES);
if(wAA > 0x10)
  wAA = 0xFF; // Type 'ALL'
wAA = (WORD)fnMakeNsQuery((char *)(&zHost[0]),wAA);
mEdAnswer += "Query made...\r\n";
fnSaveQuOrRespBinByHostName(XNS_QUERY, aBuf, wAA);
wAA = send(soS,(char *)&aBuf[0],wAA,0);
  if(wAA != SOCKET_ERROR) // Sent
  {
  mEdAnswer += "Query sent...\r\n";
  }
UpdateData(FROM_OBJECT_TO_SCREEN);
}
// =====================================================
// Save HostName
// =====================================================
void CXyzDlg::OnKillfocusEdHost() 
{
// TODO: Add your control notification handler code here
UpdateData(FROM_SCREEN_TO_OBJECT);
}
// =====================================================
// Make NS QueryPacket byHostname and QueryType
// =====================================================
LONG CXyzDlg::fnMakeNsQuery(CHAR *zQName,SH_INT iQType)
{
RNSQ_HEADER *prNsqHeader;
CHAR *pQNAME;
SH_WORD &wRLen = (SH_WORD &)*aBuf;
SH_WORD iLaLen; // LabelLen
SH_WORD static wID = 0x1234;
//
if(!*zQName)
  return(-1);
//
wRLen = 0;
// ============= Fill Header ===========================
prNsqHeader = (RNSQ_HEADER *)((CHAR *)aBuf+2); // Set pointer to RequestHeader
wRLen += sizeof(RNSQ_HEADER);
FillMemory((void*)prNsqHeader,wRLen,0);
//
prNsqHeader->xID = wID;			// ID number
// ===============================
prNsqHeader->xf.xQR = 0;		// 1.0 = Request
prNsqHeader->xf.xOPCODE = 0;	// 4.0=SQUERY
prNsqHeader->xf.xAA = 0;		// 1.0=Authoritative Answer (SetfromNameServer)
prNsqHeader->xf.xTC = 0;		// 1.0=No truncation
prNsqHeader->xf.xRD = 1;		// 1=recursion desired
//
prNsqHeader->xf.xRA = 0;		// 1.1=recursion availabel
prNsqHeader->xf.xZ = 0;			// 3.RFU-clear
prNsqHeader->xf.xRCODE = 0;		// 4.Response code = 0
//
prNsqHeader->xQDCOUNT = 1;		// Entries of questions !!!!!!! Only ONE !!!!!
prNsqHeader->xANCOUNT = 0;		// Empty Field
prNsqHeader->xNSCOUNT = 0;		// Empty Field
prNsqHeader->xARCOUNT = 0;		// Empty Field
// Reverce to Internet Format
prNsqHeader->xID = htons(prNsqHeader->xID);
*(WORD*)&prNsqHeader->xf = htons(*(WORD*)&prNsqHeader->xf);
prNsqHeader->xQDCOUNT = htons(prNsqHeader->xQDCOUNT);
prNsqHeader->xANCOUNT = htons(prNsqHeader->xANCOUNT);
prNsqHeader->xNSCOUNT = htons(prNsqHeader->xNSCOUNT);
prNsqHeader->xARCOUNT = htons(prNsqHeader->xARCOUNT);
// ============= Fill QNAME Record ======================
pQNAME = (CHAR *)aBuf+2+wRLen;
iLaLen = 0;
  do
   {
   if((*zQName == '.') || (*zQName == '\0'))
	 {
	 *(pQNAME-iLaLen) = (CHAR)iLaLen;
	 iLaLen = 0;
	 if(*zQName == '\0')
	   *(pQNAME+1) = '\0'; // EndOfString.
	 }
   else
	 {
	 *(pQNAME+1) = *zQName;
	 iLaLen ++;
	 }
   pQNAME++;
   zQName++;
   }// End WHILE
  while(*(zQName-1));
pQNAME = (CHAR *)aBuf+2+wRLen;		// Restore
wRLen += (strlen(pQNAME)+1);
// ============= Fill QTYPE Record =====================
*(SH_WORD *)(aBuf+wRLen+2) = (SH_WORD)iQType;
*(SH_WORD *)(aBuf+wRLen+2) = htons(*(SH_WORD *)(aBuf+wRLen+2));
wRLen += 2;
// ============= Fill QCLASS Record ====================
*(SH_WORD *)(aBuf+wRLen+2) = QCLASS_IN;
*(SH_WORD *)(aBuf+wRLen+2) = htons(*(SH_WORD *)(aBuf+wRLen+2));
wRLen += 2;
iLaLen = wRLen;
wRLen = htons(wRLen); // htons
// =====================================================
return((iLaLen+2)); // Return DataBlock length in buffer.
}
// =====================================================
// Analog of Linux function 'reuse()'
// =====================================================
INT CXyzDlg::fnReUse(SOCKET s)
{
int iOpVal = 0;
int ss;
ss = setsockopt(s, SOL_SOCKET, SO_REUSEADDR,
               (const CHAR *)&iOpVal, sizeof (iOpVal));
if (ss == SOCKET_ERROR)
  return(-1);
else
  return(0);
} // End of "fnReUse()".
// =====================================================
// Change Font in EditBox to 'Courier New'
// =====================================================
BOOL CXyzDlg::fnLoadFont(void)
{
LOGFONT rLF;
CWnd *w = NULL;
BOOL boolRe = LO;
// Set Parameters of Font
rLF.lfHeight = 0xFFFFFFF5;
rLF.lfWidth = 0;
rLF.lfEscapement = 0;
rLF.lfOrientation = 0;
rLF.lfWeight = 190;
rLF.lfItalic = 0;
rLF.lfUnderline = 0;
rLF.lfStrikeOut = 0;
rLF.lfCharSet = 0;
rLF.lfOutPrecision = 3;
rLF.lfClipPrecision = 2;
rLF.lfQuality = 1;
rLF.lfPitchAndFamily = 39;
strcpy(&rLF.lfFaceName[0],"Courier New");
boolRe = pcf->CreateFontIndirect(&rLF);
  if(boolRe == KEN)
  {
  w = GetDlgItem(IDC_ED_HOST);
  w->SetFont(pcf,LO);
  w = GetDlgItem(IDC_ED_ANSWER);
  w->SetFont(pcf,LO);
  w = GetDlgItem(IDC_ED_NAMESERVER);
  w->SetFont(pcf,LO);
  }
  else
  {
  AfxMessageBox("SetFont Error !!");
  }
return(boolRe);
}
// =====================================================
// Check HostName and Prepare Data for using.
// =====================================================
WORD CXyzDlg::fnGHost(CHAR *pHost,SOCKADDR_IN &rSockAddrIn)
{
WORD ii;
DWORD dwIP;
HOSTENT FAR *prHostEnt;
WORD wAA;
//
FillMemory(&rSockAddrIn,(sizeof(rSockAddrIn)),0);
//
wAA = (WORD)strlen(pHost);
//
for(ii = 0; ii < wAA; ii ++)
 {
 if(isalpha(pHost[ii]))
   break;
 }
if(ii == wAA) // This is IP address as 127.0.0.1
  {
  dwIP = inet_addr(pHost);
  if(dwIP != INADDR_NONE)
    {
    rSockAddrIn.sin_family = AF_INET;
    rSockAddrIn.sin_addr.s_addr = dwIP;
    }
  }
else
  {
  prHostEnt = gethostbyname(pHost);
    if(prHostEnt == NULL)
    {
    mEdAnswer += "HostName Error\r\n";
	wAA = 0;
	}
    else
	{
    rSockAddrIn.sin_family = prHostEnt->h_addrtype;
    memcpy (&rSockAddrIn.sin_addr, prHostEnt->h_addr, prHostEnt->h_length);
    mEdAnswer += "HostName O.K.\r\n";
	wAA = 1;
	}
  UpdateData(FROM_OBJECT_TO_SCREEN);
  }
return(wAA);
}
// =====================================================
// Check Service and Prepare Data for using.
// =====================================================
WORD CXyzDlg::fnGPort(CHAR *pPort,SERVENT &rService)
{
WORD ii;
SERVENT *prService;
WORD wAA;
wAA = (WORD)strlen(pPort);
for(ii = 0; ii < wAA; ii ++)
 {
 if(isalpha(pPort[ii]))
   break;
 }
if(ii == wAA)
  {
  wAA = (WORD)atoi(pPort);
  wAA = htons(wAA);
  mEdAnswer += "Port O.K.\r\n";
  }
else
  {
  prService = getservbyname(pPort, NULL);
    if(prService)
	{
    mEdAnswer += "Port O.K.\r\n";
	rService = *prService;
    wAA = rService.s_port;
	}
    else
	{
    mEdAnswer += "Port error.\r\n";
    wAA = 0;// 0 : Error.
	}
  }
return(wAA);
}
// =====================================================
// Save Hostname of NS server.
// =====================================================
void CXyzDlg::OnKillfocusEdNameserver() 
{
// TODO: Add your control notification handler code here
UpdateData(FROM_SCREEN_TO_OBJECT);	
}
// =====================================================
// Decode NS response. Received Binary data stored
// in buffer (by pointer), decoded data as ASCII
// string will be stored to ZeroStringBuffer (by pointer)
// Are used functions :
// fnDecodeNsHeader(),
// fnDecodeNsRrField().
// =====================================================
LONG CXyzDlg::fnDecodeNsResponse(BYTE *pbBuf, CHAR *zAnStr)
{
RNSQ_HEADER rAnH;
RRFIELD rRr;
SH_WORD wRrCnt;
SH_WORD wRrEntries;
BOOL boolRR = LO;
FillMemory((void *)&rAnH,sizeof(RNSQ_HEADER),0);
FillMemory((void *)&rRr,sizeof(RRFIELD),0);
rAnH = *(RNSQ_HEADER *)(pbBuf+2);
rAnH.xID = ntohs(rAnH.xID);
*(SH_WORD*)(&rAnH.xf) = ntohs(*(SH_WORD*)(&rAnH.xf));
rAnH.xQDCOUNT = ntohs(rAnH.xQDCOUNT);
rAnH.xANCOUNT = ntohs(rAnH.xANCOUNT);
rAnH.xNSCOUNT = ntohs(rAnH.xNSCOUNT);
rAnH.xARCOUNT = ntohs(rAnH.xARCOUNT);
//
rRr.xpbQueryBuf = (pbBuf+2);// Pointer to 1st byte of QUERY
rRr.xdwOfs = 0x000C; // Length of NS_HEADER
// ===== Beginning of processing =======================
sprintf((zAnStr+strlen(zAnStr)),"=========== Query ==========\r\n");
fnDecodeNsHeader(&rAnH, zAnStr);
wRrCnt = 0;
while(wRrCnt < 4)
{
wRrEntries = *(SH_WORD *)((&rAnH.xQDCOUNT)+(wRrCnt/* *2 */));
  while(wRrEntries)
  {
    if(!wRrCnt)
	{
    sprintf((zAnStr+strlen(zAnStr)),"============================\r\n");
    rRr.xboolRR = LO;
	}
    else
	{
	if(!boolRR)
      sprintf((zAnStr+strlen(zAnStr)),"\r\n\r\n========= Response =========\r\n");
    boolRR = rRr.xboolRR = KEN;
	}
  fnDecodeNsRrField(&rRr, zAnStr);
  sprintf((zAnStr+strlen(zAnStr)),"============================\r\n");
  wRrEntries--;
  }
wRrCnt++;
}
return(0);
}
// =====================================================
// Decode NS header. Received Binary data stored
// in buffer (by pointer to header structure),
// decoded data as ASCII string will be stored to
// ZeroStringBuffer (by pointer)
// =====================================================
LONG CXyzDlg::fnDecodeNsHeader(RNSQ_HEADER *prNsHeader, CHAR *zAns)
{
// =====================================================
// Decode Header
// =====================================================
sprintf((zAns+strlen(zAns)),"\
00. ID ------ Identifier      : %.4X\r\n\
01. QR  ----- Query/Response  : %.4X\r\n\
02. OPCODE -- Opcode          : %.4X\r\n\
03. AA ------ Autoritate      : %.4X\r\n\
04. TC ------ Truncation      : %.4X\r\n\
05. RD ------ RecursDesired   : %.4X\r\n\
06. RA ------ RecursAvailable : %.4X\r\n\
07. Z ------- RFU             : %.4X\r\n\
08. RCODE --- ResponseCode    : %.4X\r\n\
09. QDCOUNT - N of Questions  : %.4X\r\n\
0A. ANCOUNT - N of Answers    : %.4X\r\n\
0B. NSCOUNT - N of Authority  : %.4X\r\n\
0C. ARCOUNT - N 0f Additions  : %.4X\r\n\
",
prNsHeader->xID,		// 16 bits Identifier maded by program.
prNsHeader->xf.xQR,		// 1 Bit 0)query,1)response.
prNsHeader->xf.xOPCODE,	// 0)SQUERY,1)IQUERY,2)Server STATUS request.
prNsHeader->xf.xAA,		// Authoritative Answer (fromNameServer)
prNsHeader->xf.xTC,		// TrunCation (fromNameServer)
prNsHeader->xf.xRD,		// Recursion Desired (byProgram)
prNsHeader->xf.xRA,		// Recursion Available (fromNameServer)
prNsHeader->xf.xZ,		// RFU
prNsHeader->xf.xRCODE,	// ResponseCode 0) NoErrors
prNsHeader->xQDCOUNT,	// No of entries in Question section
prNsHeader->xANCOUNT,	// No of entries in Answer section
prNsHeader->xNSCOUNT,	// No of entries in Authority section
prNsHeader->xARCOUNT);	// No of entries in Addition section
// =====================================================
// 
return(0);
}
// =====================================================
// Decode NS Name from NS format to ZeroString.
// =====================================================
LONG CXyzDlg::fnDecodeNsName(CHAR *pbNm, CHAR *zAnStr, CHAR *pbQu)
{
INT iStrLen;
INT iLaLen;
INT iDataLen;
// ============= Decode NS_NAME field ==================
iStrLen = 0;
iDataLen = 0;
  do
  {
    if((*pbNm & 0xC0)==0xC0)		// IF detected NS_POINTER,
	{
	pbNm = (((BYTE)*(pbNm+0) & 0x3F)<<8)+((BYTE)*(pbNm+1) + pbQu);
	  if(iDataLen >= 0)
	  {
	  iDataLen += 2;
	  iDataLen = ~iDataLen;
	  iDataLen ++; // Make Negative value
	  }
	}
  for(iLaLen=0; iLaLen < *pbNm; iLaLen++)
	{
    *(zAnStr+iStrLen) = *(pbNm+iLaLen+1);
	iStrLen++;
	}
  pbNm += (iLaLen+1);
  if(iDataLen >= 0) // Make return value.
    iDataLen += (iLaLen+1);
  if(*pbNm)
	{
    *(zAnStr+iStrLen) = '.';
	iStrLen++;
	}
  }
  while(*(pbNm+0));
*(zAnStr+iStrLen) = '\0'; // End of String
if(iDataLen < 0) // Inverse DataLength
  {
  iDataLen = ~iDataLen;
  iDataLen ++; // Make Positive value
  }
return(iDataLen);
}
// =====================================================
// Decode NS RR-field. Received Binary data stored
// in buffer (by pointer to RR-field structure),
// decoded data as ASCII string will be stored to
// ZeroStringBuffer (by pointer)
// =====================================================
LONG CXyzDlg::fnDecodeNsRrField(RRFIELD *prRr, CHAR *zAnStr)
{
RRFIELD rRr;
CHAR *zNsName;
CHAR *zName;
LONG loRe;
//
ASSERT(prRr);
ASSERT(zAnStr);
zName = new CHAR [0x0200];
ASSERT(zName);
rRr = *prRr;
//
rRr.xpbNAME = rRr.xpbQueryBuf+rRr.xdwOfs;
  if((*rRr.xpbNAME & 0xC0) == 0xC0)	// If NAME created as NS_POINTER
  {
  rRr.xwNAMEFIELDLEN = 2;
  zNsName = (CHAR *)(rRr.xpbQueryBuf+(((*(rRr.xpbNAME+0)) & 0x3F)<<8)+(*(rRr.xpbNAME+1))); // String by NS_POINTER
  }
  else								// else usual as queue of NS_LABELs
  {
  rRr.xwNAMEFIELDLEN = (strlen((CHAR *)rRr.xpbNAME)+1);
  zNsName = (CHAR *)rRr.xpbNAME;
  }
rRr.xwTYPE = ntohs(*(SH_WORD *)(rRr.xpbNAME+rRr.xwNAMEFIELDLEN+0));
rRr.xwCLASS = ntohs(*(SH_WORD *)(rRr.xpbNAME+rRr.xwNAMEFIELDLEN+2));
if(rRr.xboolRR) // Only if AnswerField
  {
  rRr.xdwTTL = ntohl(*(DWORD *)(rRr.xpbNAME+rRr.xwNAMEFIELDLEN+2+2));
  rRr.xwRDLENGTH = ntohs(*(SH_WORD *)(rRr.xpbNAME+rRr.xwNAMEFIELDLEN+2+2+4));
  rRr.xpbRDATA = (rRr.xpbNAME+rRr.xwNAMEFIELDLEN+2+2+4+2);
  }
// =====================================================
*zName = '\0'; // Empty string
fnDecodeNsName(zNsName,zName,(CHAR *)rRr.xpbQueryBuf);
sprintf((zAnStr+(strlen(zAnStr))),"%s\r\n",zName);
if(rRr.xwTYPE <= 0x10)
sprintf((zAnStr+(strlen(zAnStr))),
		"TYPE : %s, CLASS : %s\r\n",
		aNsRrType[(rRr.xwTYPE-1)],aNsRrClass[(rRr.xwCLASS-1)]);
else
sprintf((zAnStr+(strlen(zAnStr))),
		"TYPE = ALL, CLASS = %s\r\n",
		aNsRrClass[(rRr.xwCLASS-1)]);
//
if(rRr.xboolRR) // Only if AnswerField
{
sprintf((zAnStr+(strlen(zAnStr))),"TTL : %d.\r\n",rRr.xdwTTL);
sprintf((zAnStr+(strlen(zAnStr))),"RDLENGTH : %.4X\r\n",rRr.xwRDLENGTH);
// Here must be RDATA processinng
// Process by TYPE
  switch(rRr.xwTYPE)
  {
  case RTYPE_A : //0x01 :
    sprintf((zAnStr+(strlen(zAnStr))),
            "IP address : %d.%d.%d.%d\r\n",
			*(rRr.xpbRDATA+0),
			*(rRr.xpbRDATA+1),
			*(rRr.xpbRDATA+2),
			*(rRr.xpbRDATA+3));
  break;
//
  case RTYPE_NS : // 0x02 :
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"NS server : %s\r\n",zName);
  break;
//
  case RTYPE_MD : // 0x03
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"MailDelivery Host : %s\r\n",zName);
  break;
//
  case RTYPE_MF : // 0x04
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"MailForwarding Host : %s\r\n",zName);
  break;
//
  case RTYPE_CNAME : // 0x05
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"Canonical Name Host : %s\r\n",zName);
  break;
//
  case RTYPE_SOA : // 0x06
    loRe = 0;
    loRe += fnDecodeNsName((CHAR *)(rRr.xpbRDATA+loRe),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"Primary NS server of zone : %s\r\n",zName);
    loRe += fnDecodeNsName((CHAR *)(rRr.xpbRDATA+loRe),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"Person Responsible MailBox server of zone : %s\r\n",zName);
//
sprintf((zAnStr+(strlen(zAnStr))),"\
Version Number    : $%.8X (hex).\r\n\
Refresh Time Out  : %d.\r\n\
Retry Time Out    : %d.\r\n\
Expire Time Out   : %d.\r\n\
Minimum TTL       : %d.\r\n",
htonl(*(DWORD *)(rRr.xpbRDATA+(0*4)+loRe)),
htonl(*(LONG *)(rRr.xpbRDATA+(1*4)+loRe)),
htonl(*(LONG *)(rRr.xpbRDATA+(2*4)+loRe)),
htonl(*(LONG *)(rRr.xpbRDATA+(3*4)+loRe)),
htonl(*(DWORD *)(rRr.xpbRDATA+(4*4)+loRe)));
  break;
//
  case RTYPE_MB : // 0x07
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"MailBox Host : %s\r\n",zName);
  break;
//
  case RTYPE_MG : // 0x08
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"Member of MailGroup Host : %s\r\n",zName);
  break;
//
  case RTYPE_MR : // 0x09
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"New Name of Mailbox Host : %s\r\n",zName);
  break;
//
  case RTYPE_NULL : // 0x0A
    sprintf((zAnStr+(strlen(zAnStr))),"NULL RR-TYPE : no handling !\r\n");
  break;
//
  case RTYPE_WKS : // 0x0B
    sprintf((zAnStr+(strlen(zAnStr))),"WKS RR-TYPE : no handling !\r\n");
  break;
//
  case RTYPE_PTR : // 0x0C
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+0),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"Location Pointer : %s\r\n",zName);
  break;
//
  case RTYPE_HINFO : // 0x0D
    sprintf((zAnStr+(strlen(zAnStr))),"Host Information.\r\n");
    if(rRr.xwRDLENGTH > 0x0200)
	  {
      sprintf((zAnStr+(strlen(zAnStr))),"HINFO RR-TYPE LARGE : no handling !\r\n");
	  }
	else
	  {
      loRe = 0;
	  while(loRe < rRr.xwRDLENGTH)
		{
		sprintf((zName+strlen(zName)),"%s\r\n",(CHAR *)(rRr.xpbRDATA+loRe));
		loRe += (strlen((CHAR *)(rRr.xpbRDATA+loRe))+1);
		}
      sprintf((zAnStr+(strlen(zAnStr))),"%s",zName);
	  }
  break;
//
  case RTYPE_MINFO : // 0x0E
    sprintf((zAnStr+(strlen(zAnStr))),"Mailing Information.\r\n");
    loRe = 0;
    loRe += fnDecodeNsName((CHAR *)(rRr.xpbRDATA+loRe),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"Mailing List Responsible Server : %s\r\n",zName);
    loRe += fnDecodeNsName((CHAR *)(rRr.xpbRDATA+loRe),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"Error Messages Related Server : %s\r\n",zName);
  break;
//
  case RTYPE_MX : // 0x0F
    sprintf((zAnStr+(strlen(zAnStr))),
            "Preference : %.4X (hex)\r\n",
			*((WORD *)rRr.xpbRDATA+0));
    fnDecodeNsName((CHAR *)(rRr.xpbRDATA+2),zName,(CHAR *)rRr.xpbQueryBuf);
    sprintf((zAnStr+(strlen(zAnStr))),"MX server : %s\r\n",zName);
  break;
//
  case RTYPE_TXT : // 0x10
    if(rRr.xwRDLENGTH > 0x0200)
	  {
      sprintf((zAnStr+(strlen(zAnStr))),"TEXT RR-TYPE LARGE : no handling !\r\n");
	  }
	else
	  {
      loRe = 0;
	  while(loRe < rRr.xwRDLENGTH)
		{
		sprintf((zName+strlen(zName)),"%s\r\n",(CHAR *)(rRr.xpbRDATA+loRe));
		loRe += (strlen((CHAR *)(rRr.xpbRDATA+loRe))+1);
		}
      sprintf((zAnStr+(strlen(zAnStr))),"%s",zName);
	  }
  break;
//
  default :
	  AfxMessageBox("Incorrect RR-field Type. Decode NS RR-field.");
  break;
  } // End SWITCH
}
// =====================================================
if(!rRr.xboolRR) // Only if AnswerField
  rRr.xdwOfs += (rRr.xwNAMEFIELDLEN+2+2);
else
  rRr.xdwOfs += (rRr.xwNAMEFIELDLEN+2+2+4+2+rRr.xwRDLENGTH);
*prRr = rRr;
if(zName)
  delete [] zName;
return(rRr.xdwOfs);
}
// =====================================================
// Load Binary Data from File for decoding.
// =====================================================
void CXyzDlg::OnBtnFmFile() 
{
// TODO: Add your control notification handler code here
DWORD dwRe = 0;
DWORD dwCntA;
CHAR *zNm = NULL;
zNm = new CHAR [0x0100];
ASSERT(zNm);
char *zMs = NULL;
zMs =  new char [0x0100];
ASSERT(zMs);
//
GetCurrentDirectory(0x0100,zNm);
CFileDialog fd(SSOPEN);
fd.m_ofn.lpstrTitle = "Load Query/Response Binary LogFile";
fd.m_ofn.lpstrFilter = "BIQuery Files(*.biq)\0*.biq\0BIResponse Files(*.bir)\0*.bir\0All Files(*.*)\0*.*\0\0";
fd.m_ofn.nFilterIndex = 2;
fd.m_ofn.lpstrInitialDir = zNm;//
if(fd.DoModal() == IDOK)
{
  try
  {
  sprintf(zNm, fd.m_ofn.lpstrFile);
  CFile f;
  f.Open(zNm,(CFile::modeRead));
  dwRe = f.GetLength();
  if(dwRe)
	{
    *gzAnStr = '\0';
    f.Read(aBuf,dwRe);
    fnDecodeNsResponse((BYTE *)aBuf,gzAnStr);
    mEdAnswer = gzAnStr;
    UpdateData(FROM_OBJECT_TO_SCREEN);
	}
  f.Close();
  dwCntA = strlen(zNm);
  while(*(zNm+dwCntA) != '.')
    dwCntA--;
  *(zNm+dwCntA) = '_';
  sprintf((zNm+strlen(zNm)),".sym");
  f.Open(zNm, CFile::modeCreate | CFile::modeReadWrite);
  sprintf(zMs,"-------- Results of Query -------\r\n\r\n\
**. DataBlock Length -------- : %.4X --- %d bytes.\r\n\r\n\
",dwRe,dwRe);
  f.Write(zMs,(strlen(zMs)));
  f.Write(gzAnStr,(strlen(gzAnStr)));
  f.Close();
  }
  catch(CFileException *e)
  {
  if(e->m_cause != CFileException::none)
    MessageBox("Binary BIQ/R LogFileOpen Error !! FromFile.");
  }
}
// ===================================================
if(zMs)
  delete [] zMs;
if(zNm)
  delete [] zNm;
}
// =====================================================
// Count String for correct output to screen (to EditBox)
// Input  : Quantity of binaries bytes
// Output : Quantity bytes for ASCII string with alighnment
// =====================================================
DWORD CXyzDlg::fnCountString(DWORD dwNbt, BOOL boolAsc)
{
DWORD dwNbtOut = 0;
dwNbt = ((dwNbt & 0xFFFFFFF0)+0x10);
if(boolAsc)
  dwNbtOut = (dwNbt*(3+2)) + ((dwNbt/0x10)*(8+2));
else
  dwNbtOut = (dwNbt*3) + ((dwNbt/0x10)*2);
return(dwNbtOut+0x10);
}
// =====================================================
// Make ASCII string in two formats :
// in left part - quasi binary data,
// in right part - symbol data.
// =====================================================
DWORD CXyzDlg::fn2OutModes(CHAR *pbFm, CHAR *pbTo, DWORD dwNbt, BOOL boolAsc)
{
CHAR cc;				// Symbol
CHAR mn;				// Most nibble
CHAR ln;				// Least nibble
DWORD dwCnt;			// Counters
WORD w16;				//
WORD w16a;				//
DWORD dwRe;				// Result.
//
if(!dwNbt || !pbFm || !pbTo)
  return(0);
//
dwRe = 0;
//
dwCnt = dwNbt;
while(dwCnt)
{
if(dwCnt < 0x10)
  w16 = (WORD)dwCnt;
else
  w16 = 0x10;
dwCnt -= w16;
//
w16a = 0;
//
  while(w16)
  {
  cc = *(pbFm+w16a);
  mn = ((cc & 0xF0) >> 4);
  ln = (cc & 0x0F);
  mn = tbXlat[mn];
  ln = tbXlat[ln];
//
  *pbTo = mn;
  pbTo++;
//
  *pbTo = ln;
  pbTo++;
//
  *pbTo = 0x20;
  pbTo++;
//
  w16a++;
  w16--;
  } // End WHILE Cnt Hex string
// =====================================================
if(boolAsc)
{
w16 = 8;
while(w16--)
  *pbTo++ = 0x20;
//
w16 = w16a;
w16a = 0;
  while(w16)
  {
  cc = *(pbFm+w16a);
  if(cc < 0x20)
    *pbTo = '.';
  else
    *pbTo = cc;
//
  pbTo++;
  w16a++;
  w16--;
  } // End WHILE Cnt Ascii string
*pbTo = '\r';
pbTo++;
*pbTo = '\n';
pbTo++;
} // End IF AsciiOutput too.
pbFm += w16a;
dwRe += w16a;
} // End WHILE dwCnt
*pbTo = '\0'; // Last byte
//
return(dwRe);
}
// =====================================================
// Convert from binary to ASCII
// =====================================================
void CXyzDlg::OnBtnBin2Ascii() 
{
// TODO: Add your control notification handler code here
CHAR *pbBin = NULL;
CHAR *pbAsc = NULL;
CHAR *zNm = NULL;
DWORD dwCntA,dwCntB;
pbBin = NULL;
WORD wAA = 0;
CFile *ff;
// TODO: Add your control notification handler code here
//
zNm = new CHAR [0x0100];
ASSERT(zNm);
GetCurrentDirectory(0x0100,zNm);
//
CFileDialog fd(SSOPEN);
fd.m_ofn.lpstrTitle = "Load Query/Response Binary LogFile";
fd.m_ofn.lpstrFilter = "BIQuery Files(*.biq)\0*.biq\0BIResponse Files(*.bir)\0*.bir\0All Files(*.*)\0*.*\0\0";
fd.m_ofn.nFilterIndex = 2;
fd.m_ofn.lpstrInitialDir = zNm;//
if(fd.DoModal() == IDOK)
  {
  wAA = wAA;
  try
	{
    ff = new CFile(fd.m_ofn.lpstrFileTitle,(CFile::modeReadWrite));
	dwCntB = (ff->GetLength());
	dwCntB = ((dwCntB & 0xFFFFFFF0) + 0x20);
	pbBin = new CHAR [dwCntB];
	ASSERT(pbBin);
	FillMemory((VOID *)pbBin, dwCntB, 0);
	ff->Read((VOID *)pbBin,dwCntB);
	ff->Close();
	delete ff;
// ====================================================
	dwCntA = fnCountString(dwCntB, KEN);
	pbAsc = new CHAR [dwCntA];
	ASSERT(pbAsc);
	dwCntA = fn2OutModes(pbBin,pbAsc,dwCntB, KEN);
    if(zNm)
	  {
      sprintf(zNm,fd.m_ofn.lpstrFile);
      dwCntA = strlen(zNm);
	  while(*(zNm+dwCntA) != '.')
		dwCntA--;
	  *(zNm+dwCntA) = '_';
      sprintf((zNm+strlen(zNm)),".hex");
      ff = new CFile(zNm,(CFile::modeCreate | CFile::modeReadWrite));
      ASSERT(ff);
      ff->Write(pbAsc, (strlen(pbAsc)));
      ff->Close();
	  delete ff;
	  mEdAnswer = pbAsc;
	  UpdateData(FROM_OBJECT_TO_SCREEN);
	  }
	} // End try
  catch(CFileException *e)
	{
	if(e->m_cause != CFileException::none)
      MessageBox("Binary BIQ/R LogFileOpen Error !! BinToAscii.");
	}
  } // End IF IDOK
if(pbAsc)
  delete [] pbAsc;
if(pbBin)
  delete [] pbBin;
if(zNm)
  delete [] zNm;
}
// =====================================================
// MenuCommand as duplicate
// =====================================================
void CXyzDlg::MnuBin2Ascii()
{
OnBtnBin2Ascii();
}
// =====================================================
// MenuCommand as duplicate
// =====================================================
void CXyzDlg::MnuFmFile()
{
OnBtnFmFile();
}
// =====================================================
// No comments.
// =====================================================
void CXyzDlg::MnuOpen()
{
CHAR *zNm;
DWORD dwRe;
zNm = new CHAR [MAXFILENAME];
CFileDialog fd(SSOPEN);
fd.m_ofn.lpstrTitle = "Load Query/Response Text Files";
fd.m_ofn.lpstrFilter = "Ascii HEX Files(*.hex)\0*.hex\0Ascii SYM Files(*.sym)\0*.sym\0All Files(*.*)\0*.*\0\0";
fd.m_ofn.nFilterIndex = 2;
fd.m_ofn.lpstrInitialDir = zCurrentDir;//
if(fd.DoModal() == IDOK)
{
  try
  {
  sprintf(zNm, fd.m_ofn.lpstrFile);
  CFile f;
  f.Open(zNm,(CFile::modeRead));
  dwRe = f.GetLength();
  if(dwRe < 0x4000)
	{
    f.Read(gzAnStr,dwRe);
	*(gzAnStr + dwRe) = '\0';
    mEdAnswer = gzAnStr;
    UpdateData(FROM_OBJECT_TO_SCREEN);
	}
  else
	{
	AfxMessageBox("Open File error. Length. Menu. Open File.");
	}
  f.Close();
  }
  catch(CFileException *e)
  {
  if(e->m_cause != CFileException::none)
    MessageBox("Ascii LogFileOpen Error !! Menu. Open File.");
  }
}
if(zNm)
  delete [] zNm;
}
//
void CXyzDlg::MnuSaveAs()
{
// =====================================================
// No comments.
// =====================================================
CHAR *zNm;
DWORD dwRe;
zNm = new CHAR [MAXFILENAME];
CFileDialog fd(SSSAVE);
fd.m_ofn.lpstrTitle = "Save Text File";
fd.m_ofn.lpstrFilter = "Ascii TEXT Files(*.txt)\0*.txt\0All Files(*.*)\0*.*\0\0";
fd.m_ofn.nFilterIndex = 1;
fd.m_ofn.lpstrInitialDir = zCurrentDir;//
if(fd.DoModal() == IDOK)
{
  try
  {
  sprintf(zNm, fd.m_ofn.lpstrFile);
  CFile f;
  f.Open(zNm,(CFile::modeCreate | CFile::modeReadWrite));
  dwRe = mEdAnswer.GetLength();
  if(dwRe)
	{
    f.Write(mEdAnswer,dwRe);
	}
  f.Close();
  }
  catch(CFileException *e)
  {
  if(e->m_cause != CFileException::none)
    MessageBox("Ascii LogFileOpen Error !! Menu. Open File.");
  }
}
if(zNm)
  delete [] zNm;
}
// =====================================================
// Save Query or Response, generate FileName by HostName.
// =====================================================
LONG CXyzDlg::fnSaveQuOrRespBinByHostName(BOOL boolDaType, CHAR * pbBuf, WORD wLe)
{
CHAR *zFullName = NULL;
LPCTSTR pbHost;
CHAR *pbFile;
CFile *ff;
//
pbHost = (LPCTSTR) mEdHost;
zFullName = new CHAR [MAXFILENAME];
ASSERT(zFullName);
// =====================================================
// Make FileName by HostName (without dots).
// =====================================================
*zFullName = 0;
if(zCurrentDir[strlen(zCurrentDir)-1] != 0x5C) // $5C = '\'
  sprintf(zFullName,"%s\\",zCurrentDir);
else
  sprintf(zFullName,"%s",zCurrentDir);
pbFile = (zFullName+strlen(zFullName));
do
{
if(*pbHost != '.')
  {
  *pbFile = *pbHost;
  pbFile++;
  }
pbHost++;
}
while(*(pbHost-1));
if(!boolDaType)
  strcat(zFullName,".biq");
else
  strcat(zFullName,".bir");
UpdateData(FROM_OBJECT_TO_SCREEN);
// =====================================================
// Save Binary Buffer To File :
// Query -> *.biq, Response -> *.bir
// =====================================================
  try
  {
  ff = new CFile(zFullName,(CFile::modeCreate | CFile::modeReadWrite));
  ff->Write(pbBuf, wLe);
  ff->Close();
  delete ff;
  }
  catch(CFileException *e)
  {
  if(e->m_cause != CFileException::none)
    MessageBox("BinaryHostLogFile Error !!");
  wLe = 0;
  }
// =====================================================
if(zFullName)
  delete [] zFullName;
return(wLe);
}
// =====================================================
// Get Query Type from control.
// =====================================================
INT CXyzDlg::fnGetQueryType(WORD wID)
{
CComboBox *cb = (CComboBox *)GetDlgItem(wID);
// Return TYPE by RFC (1 - A, 2 - NS ... etc)
return((cb->GetCurSel()+1));
}
// =====================================================
// OnRegisteredMessageFunction, which will be called
// after Selected Socket Event. (see AFX_MSG_MAP)
// =====================================================
LONG CXyzDlg::fnOnNsSockMsg(SOCKET wFmSocket,LONG loEvent)
{
//#define WSAGETSELECTERROR(lParam)       HIWORD(lParam)
//#define WSAGETSELECTEVENT(lParam)       LOWORD(lParam)
WORD wError;
WORD wEvent;
INT iRe;
//
wError = WSAGETSELECTERROR(loEvent);
wEvent = WSAGETSELECTEVENT(loEvent);
iRe= 0;
switch(wEvent)
{
case FD_CONNECT :
	if(!wError)
      mEdAnswer += "Connection established...\r\n";
	else
      mEdAnswer += "Connection not established...\r\n";
break;
//
case FD_READ :
  iRe = recv(soS,(char *)aBuf,MAXSOCKBUFF,0);
    if(iRe != SOCKET_ERROR)
	{
    mEdAnswer += "Data Received...\r\nReceived Data in buffer...\r\n";
	fnSaveQuOrRespBinByHostName(XNS_RESPONSE, aBuf, iRe);
    mEdAnswer += "Data Saved on disk...\r\n";
	Sleep(5);
	*gzAnStr = 0;
    fnDecodeNsResponse((BYTE *)aBuf,gzAnStr);
	}
	else
	{
    mEdAnswer += "Receive error...\r\n";
	}
break;
//
default :
break;
} // End SWITCH
UpdateData(FROM_OBJECT_TO_SCREEN);
return(0);
}
