#include <windows.h>
#include <windowsx.h>

#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glaux.h>

// Global variables
static	HGLRC hRC;		// rendering context
static	HDC hDC;		// device context

BOOL	keys[256];		// array for kbd routine

// Functions
GLvoid Initial(GLsizei Width, GLsizei Height);
GLvoid Resize(GLsizei Width, GLsizei Height);
GLvoid Draw(GLvoid);
LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);


// Implementation
GLvoid Initial(GLsizei Width, GLsizei Height)
{
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	// this will clear background color

	glClearDepth(1.0);
	glDepthFunc(GL_LESS);
	glEnable(GL_DEPTH_TEST);

	glShadeModel(GL_SMOOTH);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, (GLfloat)Width / (GLfloat)Height, 0.1f, 100.0f);
	glMatrixMode(GL_MODELVIEW);
}

GLvoid Resize(GLsizei Width, GLsizei Height)
{
	if(Height==0)
		Height = 1;
	glViewport(0, 0, Width, Height);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, (GLfloat)Width / (GLfloat)Height, 0.1f, 100.0f);

	glMatrixMode(GL_MODELVIEW);
}

GLvoid Draw(GLvoid)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();

	glTranslatef(-1.5f, 0.0f, -5.0f);
	glBegin(GL_TRIANGLES);
		glColor3f(1.0f, 0.0f, 0.0f);
		glVertex3f( 0.0f, 1.0f, 0.0f);	// Top
		glColor3f(0.0f, 1.0f, 0.0f);
		glVertex3f(-1.0f,-1.0f, 0.0f);	// Bottom Left
		glColor3f(0.0f, 0.0f, 1.0f);
		glVertex3f( 1.0f,-1.0f, 0.0f);	// Bottom Right
	glEnd();

	glLoadIdentity();
	glTranslatef(1.5f, 0.0f, -5.0f);
	glColor3f(0.3f, 0.2f, 0.4f);
	glBegin(GL_QUADS);
		glVertex3f(-1.0f, 1.0f, 0.0f);	// Top Left
		glVertex3f( 1.0f, 1.0f, 0.0f);	// Top Right
		glVertex3f( 1.0f,-1.0f, 0.0f);	// Bottom Right
		glVertex3f(-1.0f,-1.0f, 0.0f);	// Bottom Left
	glEnd();
}


LRESULT CALLBACK WndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	RECT Screen;
	GLuint PixelFormat;

	static PIXELFORMATDESCRIPTOR pfd =
	{
		sizeof(PIXELFORMATDESCRIPTOR),		// 
		1,									//  ?
		PFD_DRAW_TO_WINDOW|					// format must support Window
		PFD_SUPPORT_OPENGL|					// format must support OpenGL
		PFD_DOUBLEBUFFER,					// must support double buffer
		PFD_TYPE_RGBA,						//  RGBA 
		16,									// 16Bit color depth
		0, 0, 0, 0, 0, 0,					// Color bits ignored ?
		0,									// No Alpha buffer
		0,									// shift bit ignored
		0,									// no accumulation buffer
		0, 0, 0, 0,							// accumulation buffer bits ignored
		16,									// 16bit z-buffer (depth buffer)
		0,									// no stencil buffer
		0,									// no auxiliary buffer
		PFD_MAIN_PLANE,						// main drawing layer
		0,									// reserved
		0, 0, 0								// layer mask ignored
	};

	switch(msg)
	{
	case WM_CREATE:
		hDC = GetDC(hWnd);
		PixelFormat = ChoosePixelFormat(hDC, &pfd);

		if(!PixelFormat){
			MessageBox(0, "Can't find suitable PixelFormat","Error", MB_OK|MB_ICONERROR);
			PostQuitMessage(0);
			break;
		}

		if(!SetPixelFormat(hDC, PixelFormat, &pfd)) {
			MessageBox(0, "Can't set The PixelFormat","Error",MB_OK|MB_ICONERROR);
			PostQuitMessage(0);
			break;
		}
		hRC = wglCreateContext(hDC);
		if(!hRC) {
			MessageBox(0, "Can't Create Render Device Context","Error",MB_OK|MB_ICONERROR);
			PostQuitMessage(0);
			break;
		}
		if(!wglMakeCurrent(hDC, hRC)) {
			MessageBox(0, "Can't set current Render Device Context","Error",MB_OK|MB_ICONERROR);
			PostQuitMessage(0);
			break;
		}

		GetClientRect(hWnd, &Screen);
		Initial(Screen.right, Screen.bottom);
		break;
	case WM_CLOSE:
	case WM_DESTROY:
		ChangeDisplaySettings(NULL, 0);

		wglMakeCurrent(hDC, NULL);
		wglDeleteContext(hRC);
		ReleaseDC(hWnd, hDC);

		PostQuitMessage(0);
		break;
	case WM_KEYDOWN:
		keys[wParam] = TRUE;
		break;
	case WM_KEYUP:
		keys[wParam] = FALSE;
		break;
	case WM_SIZE:
		Resize(LOWORD(lParam), HIWORD(lParam));
		break;
	default:
		return( DefWindowProc(hWnd, msg, wParam, lParam));
	}
	return(0);
}


int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmd, int nShowCmd)
{
	MSG			msg;
	WNDCLASS	wc;
	HWND		hWnd;

	wc.style		= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc	= (WNDPROC)WndProc;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= hInst;
	wc.hIcon		= NULL;
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= NULL;
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= "ColorTriQuad";

	if(!RegisterClass(&wc)) 
	{
		MessageBox(0,"Error Create window class","Error", MB_OK|MB_ICONERROR);
		return FALSE;
	}

	hWnd = CreateWindow("ColorTriQuad",
		"ColorTriQuad",
		WS_POPUP |
		WS_CLIPCHILDREN |
		WS_CLIPSIBLINGS,
		0, 
		0, 
		800, 
		600, 
		NULL, 
		NULL, 
		hInst, 
		NULL);

	if(!hWnd){
		MessageBox(0,"Error Create window","Error",MB_OK|MB_ICONERROR);
		return FALSE;
	}

	DEVMODE dmScreenSettings;

	memset(&dmScreenSettings, 0, sizeof(DEVMODE));
	dmScreenSettings.dmSize			= sizeof(DEVMODE);
	dmScreenSettings.dmPelsWidth	= 800;
	dmScreenSettings.dmPelsHeight	= 600;
	dmScreenSettings.dmFields		= DM_PELSWIDTH | DM_PELSHEIGHT;
	ChangeDisplaySettings(&dmScreenSettings, CDS_FULLSCREEN);

	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
	SetFocus(hWnd);

	while(1)
	{
		while(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(GetMessage(&msg, NULL, 0, 0))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			else
			{
				return TRUE;
			}
		}

		Draw();
		SwapBuffers(hDC);

		if(keys[VK_ESCAPE]) SendMessage(hWnd, WM_CLOSE, 0, 0);
	}
}

