//				Step18
//    (firststeps.narod.ru)
//			  (1999-2001)
//			      11.07.2001 .



#include "stdafx.h"
#include "iostream.h"
#include "oledb.h"      // OLE DB 
#include "oledberr.h" 


// OLE DB - ODBC 
#include "msdaguid.h"
#include "msdasql.h"
 

#define NUMROWS_CHUNK     35

void main()
{

HRESULT hr;
IDBInitialize* pIDBInitialize = NULL;

//    
const ULONG   nProps = 4;
IDBProperties*  pIDBProperties;
DBPROP    InitProperties[nProps];
DBPROPSET   rgInitPropSet;
  
//    
IDBCreateSession* pIDBCreateSession;
IDBCreateCommand* pIDBCreateCommand;

//    
ICommandText*   pICommandText;
LPCOLESTR wSQLString = OLESTR("SELECT CompanyName,City, Phone, Fax FROM Customers ORDER BY CompanyName, City");
IRowset*    pIRowset;
LONG      cRowsAffected;
       
//         
IColumnsInfo* pIColumnsInfo;
ULONG     nCols;
DBCOLUMNINFO* pColumnsInfo = NULL;
OLECHAR*    pColumnStrings = NULL;

//         Accessor  
DBBINDING* pDBBindings;    
ULONG   cbRow = 0;
IAccessor*  pIAccessor; 
HACCESSOR   hAccessor; 
DBBINDSTATUS* pDBBindStatus = NULL;

//   
ULONG     cRowsObtained;
HROW    rghRows[NUMROWS_CHUNK];   
HROW*     pRows = &rghRows[0];
char*     pRowValues;

//  COM
if  (  FAILED(  CoInitialize(  NULL  ))) 
 {
   cout << "Unable to initialize COM" << endl;
   return ;
 }

hr=CoCreateInstance(CLSID_MSDASQL, NULL, CLSCTX_INPROC_SERVER,IID_IDBInitialize, (void **) &pIDBInitialize);
if (FAILED(hr)) 
{
      cout << "CoCreateInstance Failed" << endl;
	  CoUninitialize();
	  return;
}

//  
//   
for (ULONG i = 0; i < nProps; i++ )
{
    VariantInit(&InitProperties[i].vValue);
    InitProperties[i].dwOptions = DBPROPOPTIONS_REQUIRED;
    InitProperties[i].colid = DB_NULLID;
}
// 
InitProperties[0].dwPropertyID = DBPROP_INIT_PROMPT;
InitProperties[0].vValue.vt = VT_I2;
InitProperties[0].vValue.iVal = DBPROMPT_NOPROMPT;
// 
InitProperties[1].dwPropertyID = DBPROP_INIT_DATASOURCE;
InitProperties[1].vValue.vt = VT_BSTR;
InitProperties[1].vValue.bstrVal = SysAllocString(OLESTR("OLE_DB_NWind_Jet"));
// 
InitProperties[2].dwPropertyID = DBPROP_AUTH_USERID;
InitProperties[2].vValue.vt = VT_BSTR;
InitProperties[2].vValue.bstrVal = SysAllocString(OLESTR(""));
// 
InitProperties[3].dwPropertyID = DBPROP_AUTH_PASSWORD;
InitProperties[3].vValue.vt = VT_BSTR;
InitProperties[3].vValue.bstrVal = SysAllocString(OLESTR(""));

//  
rgInitPropSet.guidPropertySet = DBPROPSET_DBINIT;
rgInitPropSet.cProperties = nProps;
rgInitPropSet.rgProperties = InitProperties;

//   
pIDBInitialize->QueryInterface(IID_IDBProperties, (void**)&pIDBProperties);
//  
hr = pIDBProperties->SetProperties(1, &rgInitPropSet);
//  
SysFreeString(InitProperties[1].vValue.bstrVal);
SysFreeString(InitProperties[2].vValue.bstrVal);
SysFreeString(InitProperties[3].vValue.bstrVal);
//  
pIDBProperties->Release();

//    
if  (FAILED(hr)) 
 {
	cout << "Unable to set Propertes" << endl;
	pIDBInitialize->Release();
	CoUninitialize();
   return ;
 }

hr=pIDBInitialize->Initialize();
if (FAILED(hr))
{
	cout << "Unable to initialize IDBInitialize" << endl;
	switch (hr)
	{
	case DB_S_ASYNCHRONOUS:
		cout << "DB_S_ASYNCHRONOUS" << endl;
		break;
    case DB_S_ERRORSOCCURRED:
		cout << "DB_S_ERRORSOCCURRED" << endl;
		break;
    case E_FAIL:
		cout << "E_FAIL" << endl;
		break;
    case E_OUTOFMEMORY:
		cout << "E_OUTOFMEMORY" << endl;
		break;
    case E_UNEXPECTED:
		cout << "E_UNEXPECTED" << endl;
		break;
	case DB_E_ALREADYINITIALIZED:
		cout << "DB_E_ALREADYINITIALIZED" << endl;
		break;
    case DB_E_CANCELED:
		cout << "DB_E_CANCELED" << endl;
		break;
    case DB_E_ERRORSOCCURRED:
		cout << "DB_E_ERRORSOCCURRED" << endl;
		break;
    case DB_SEC_E_AUTH_FAILED:
		cout << "DB_SEC_E_AUTH_FAILED" << endl;
		break;
	default:
		cout << " ????? " << endl;
		break;
	}	
	pIDBInitialize->Release(); 
	CoUninitialize();
	return;
}
//     
//
hr=pIDBInitialize->QueryInterface(IID_IDBCreateSession, (void**) &pIDBCreateSession);
if (FAILED(hr))
{
	cout << "Error Quiery Session" << endl;
	pIDBInitialize->Uninitialize();
	pIDBInitialize->Release(); 
	CoUninitialize();
	return;
}
//     
hr = pIDBCreateSession->CreateSession(NULL, IID_IDBCreateCommand,(IUnknown**) &pIDBCreateCommand);
if (FAILED(hr))
    {
	cout << "Error Create session" << endl;
	pIDBCreateSession->Release();  
	pIDBInitialize->Uninitialize();
	pIDBInitialize->Release(); 
	CoUninitialize();
	return;
	}
pIDBCreateSession->Release();  

//   
hr = pIDBCreateCommand->CreateCommand(NULL, IID_ICommandText,(IUnknown**) &pICommandText);
if (FAILED(hr))
{
	cout << "Error create command object" << endl;
	pIDBInitialize->Uninitialize();
	pIDBInitialize->Release(); 
	CoUninitialize();
	return;
}
pIDBCreateCommand->Release();

//    SQL
pICommandText->SetCommandText(DBGUID_DBSQL, wSQLString);
hr = pICommandText->Execute(NULL, IID_IRowset, NULL,&cRowsAffected, (IUnknown**) &pIRowset);
if (FAILED(hr))
{
	cout << "Error Execute Command" << endl;
	pICommandText->Release();
	pIDBInitialize->Uninitialize();
	pIDBInitialize->Release(); 
	CoUninitialize();
	return;
}	
pICommandText->Release();

//    
hr=pIRowset->QueryInterface(IID_IColumnsInfo, (void**)&pIColumnsInfo);
if (FAILED(hr))
{
	pIRowset->Release(); 
	cout << "Error GetInfo Tables" << endl;
	pIDBInitialize->Uninitialize();
	pIDBInitialize->Release(); 
	CoUninitialize();
	return;
}


hr = pIColumnsInfo->GetColumnInfo(&nCols, &pColumnsInfo,&pColumnStrings);
if (FAILED(hr))
{
	cout << "Error GetColumnInfo" << endl;
	pIRowset->Release();
	pIColumnsInfo->Release(); 
	pIDBInitialize->Uninitialize();
	pIDBInitialize->Release(); 
	CoUninitialize();
	return;
}  

cout << nCols << endl;

pDBBindings = new DBBINDING[nCols];

for (ULONG nCol = 0; nCol < nCols; nCol++)
{
    pDBBindings[nCol].iOrdinal = nCol+1;
    pDBBindings[nCol].obValue = cbRow;
    pDBBindings[nCol].obLength = 0;
    pDBBindings[nCol].obStatus = 0;
    pDBBindings[nCol].pTypeInfo = NULL;
    pDBBindings[nCol].pObject = NULL;
    pDBBindings[nCol].pBindExt = NULL;
    pDBBindings[nCol].dwPart = DBPART_VALUE;
    pDBBindings[nCol].dwMemOwner = DBMEMOWNER_CLIENTOWNED;
    pDBBindings[nCol].eParamIO = DBPARAMIO_NOTPARAM;
    pDBBindings[nCol].cbMaxLen = pColumnsInfo[nCol].ulColumnSize + 1;
    pDBBindings[nCol].dwFlags = 0;
    pDBBindings[nCol].wType = pColumnsInfo[nCol].wType;
    pDBBindings[nCol].bPrecision = pColumnsInfo[nCol].bPrecision;
    pDBBindings[nCol].bScale = pColumnsInfo[nCol].bScale;
    cbRow += pDBBindings[nCol].cbMaxLen;
}

pRowValues = new char[cbRow];

hr=pIRowset->QueryInterface(IID_IAccessor, (void**) &pIAccessor);
if (FAILED(hr))
{
	delete [] pDBBindings;
	pIRowset->Release();
	pIColumnsInfo->Release();
	pIDBInitialize->Uninitialize();
	pIDBInitialize->Release(); 
	//  COM
	CoUninitialize();
}

pDBBindStatus = new DBBINDSTATUS[nCols];

pIAccessor->CreateAccessor(DBACCESSOR_ROWDATA,nCols, 
    pDBBindings,0,&hAccessor,pDBBindStatus);

while (TRUE)
{
pIRowset->GetNextRows(0,0,NUMROWS_CHUNK,&cRowsObtained,&pRows );  
if (cRowsObtained == 0)  break;
for (ULONG iRow=0; iRow < cRowsObtained; iRow++)
    {
	
		pIRowset->GetData(rghRows[iRow], hAccessor, pRowValues);
    	printf("\t%s\n",&pRowValues[pDBBindings[1].obValue]);
	}
}
    
delete [] pRowValues;
delete [] pDBBindStatus;
delete [] pDBBindings;

pIAccessor->ReleaseAccessor(hAccessor, NULL);  
pIAccessor->Release(); 
pIRowset->Release();
pIColumnsInfo->Release();
pIDBInitialize->Uninitialize();
pIDBInitialize->Release(); 
//  COM
CoUninitialize();
}






