// CDPlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CDPlayer.h"
#include "CDPlayerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCDPlayerDlg dialog

CCDPlayerDlg::CCDPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCDPlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCDPlayerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCDPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCDPlayerDlg)
	DDX_Control(pDX, IDC_OPEN_DOOR, m_openDoor);
	DDX_Control(pDX, IDC_CLOSE_DOOR, m_closeDoor);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCDPlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CCDPlayerDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN_DOOR, OnOpenDoor)
	ON_BN_CLICKED(IDC_CLOSE_DOOR, OnCloseDoor)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCDPlayerDlg message handlers

BOOL CCDPlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	//////////////////////////////
	//    
	//////////////////////////////
	mciOpenParms.lpstrDeviceType = "cdaudio";

	DWORD resume = mciSendCommand(0, MCI_OPEN, MCI_OPEN_TYPE, (DWORD) (LPVOID)& mciOpenParms);

	if (resume == 0)
		wDeviceID = mciOpenParms.wDeviceID;
	else
	{
		m_openDoor.EnableWindow(FALSE);
		m_closeDoor.EnableWindow(FALSE);
	}
	/////////////////////////////////
	//    
	/////////////////////////////////

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCDPlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCDPlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCDPlayerDlg::OnOpenDoor() 
{
	// 
	mciSendCommand(wDeviceID, MCI_SET, MCI_SET_DOOR_OPEN, (DWORD)& mciSetParms);
}

void CCDPlayerDlg::OnCloseDoor() 
{
	// 
	mciSendCommand(wDeviceID, MCI_SET, MCI_SET_DOOR_CLOSED, (DWORD)& mciSetParms);
}
