//-----------------------------------------------------------------------------
//
//			->	 15 -    
//			->	http://www.firststeps.ru
//	  24.08.2002
//  :      ->    evgeniu@atnet.ru
//-----------------------------------------------------------------------------
#include "afxwin.h"						// MFC    

#define APPNAME "http://www.firststeps.ru    15 -    "
#include <d3d8.h>
#include <d3dx8math.h>
#include <mmsystem.h>
#pragma comment (lib, "d3d8.lib")
#pragma comment (lib, "d3dx8.lib")

#define _RELEASE_(p) { if(p) { (p)->Release(); (p)=NULL; };};
#define _DELETE_(p)  { if(p) { delete (p);     (p)=NULL; };};

#define D3DFVF_CUSTOMVERTEX ( D3DFVF_XYZ | D3DFVF_NORMAL )

struct CUSTOMVERTEX { float x, y, z, nx, ny, nz; };

class CMainWnd : public CFrameWnd
{
private:
	LPDIRECT3D8             p_d3d;						//    
	LPDIRECT3DDEVICE8		p_d3d_Device;				//   d3d8
	D3DDISPLAYMODE			d3ddm;						//  
	D3DPRESENT_PARAMETERS	d3dpp;						//  
	LPDIRECT3DVERTEXBUFFER8 p_VertexBuffer;				//   
	D3DXMATRIX				matWorld;					//  
    D3DXMATRIX				matView;					//  
    D3DXMATRIX				matProj;					//  
	D3DLIGHT8				light;						//  
	DECLARE_MESSAGE_MAP()
public: 
	int color;
	CMainWnd();											//   
	~CMainWnd(void);									//   
	void Transform3D(void);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
};

BEGIN_MESSAGE_MAP(CMainWnd, CFrameWnd)
	ON_WM_PAINT()
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()

CMainWnd::~CMainWnd(void)
{
	_RELEASE_	(p_VertexBuffer);
	_DELETE_	(p_VertexBuffer);
	_RELEASE_	(p_d3d_Device);
	_DELETE_	(p_d3d_Device);
	_RELEASE_	(p_d3d);
	_DELETE_	(p_d3d);
}

CMainWnd::CMainWnd()
{ 
	p_VertexBuffer = NULL;

	CUSTOMVERTEX g_Vertices[] =
	{
		{  0.0f,   0.0f,  0.0f, 0.0f, 0.0f, 0.0f,},
		{  0.0f, 100.0f,  0.0f, 0.0f, 0.0f, 0.0f,},
		{ 60.0f,   0.0f,  0.0f, 0.0f, 0.0f, 0.0f,},

		{  0.0f, 100.0f,  0.0f, 0.0f, 0.0f, 0.0f,},
		{ 60.0f,   0.0f, 60.0f, 0.0f, 0.0f, 0.0f,},
		{ 60.0f,   0.0f,  0.0f, 0.0f, 0.0f, 0.0f,},

		{  0.0f,   0.0f,  0.0f, 0.0f, 0.0f, 0.0f,},
		{ 60.0f,   0.0f, 60.0f, 0.0f, 0.0f, 0.0f,},
		{  0.0f, 100.0f,  0.0f, 0.0f, 0.0f, 0.0f,},
	};

	Create(NULL, APPNAME,				//   
		WS_POPUP,
		rectDefault, NULL,NULL);

	p_d3d = Direct3DCreate8 (D3D_SDK_VERSION);
	
	p_d3d->GetAdapterDisplayMode (D3DADAPTER_DEFAULT, &d3ddm);

	ZeroMemory (&d3dpp, sizeof(d3dpp));
	d3dpp.BackBufferWidth = 1024;
	d3dpp.BackBufferHeight = 768;
	d3dpp.BackBufferCount = 3;
	d3dpp.FullScreen_RefreshRateInHz = d3ddm.RefreshRate;
	d3dpp.Windowed = false;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.BackBufferFormat = d3ddm.Format;
	d3dpp.EnableAutoDepthStencil = true;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D32;

	p_d3d->CreateDevice (D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, m_hWnd, 
		D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &p_d3d_Device);

	p_d3d_Device->CreateVertexBuffer (sizeof(g_Vertices), 
		0, 
		D3DFVF_CUSTOMVERTEX, D3DPOOL_MANAGED, 
		&p_VertexBuffer);

	VOID* pVertices;
	p_VertexBuffer->Lock (0, sizeof(g_Vertices), (BYTE**)&pVertices, 0);
	memcpy (pVertices, g_Vertices, sizeof(g_Vertices));
	p_VertexBuffer->Unlock();

	D3DXVECTOR3 vecDir;
	ZeroMemory (&light, sizeof(D3DLIGHT8));
	light.Type = D3DLIGHT_DIRECTIONAL;

	light.Diffuse.r  = 1.0f;		//   
	light.Diffuse.g  = 1.0f;
	light.Diffuse.b  = 1.0f;

	vecDir = D3DXVECTOR3 (0.0f, 0.0f, 1.0f);
	D3DXVec3Normalize ((D3DXVECTOR3*)&light.Direction, &vecDir);

	light.Range = 1000.0f;

	p_d3d_Device->SetLight (0, &light);
	p_d3d_Device->LightEnable (0, true);
}

void CMainWnd::Transform3D(void)
{
	static float x;
	x = (float)(x + 0.03);

	D3DXMatrixRotationY (&matWorld, x);
	p_d3d_Device->SetTransform (D3DTS_WORLD, &matWorld);
  
	D3DXMatrixLookAtLH (&matView, &D3DXVECTOR3 (0.0f, 0.0f, -500.0f),
        &D3DXVECTOR3 (0.0f, 0.0f, 0.0f),
        &D3DXVECTOR3 (0.0f, 1.0f, 0.0f));
	p_d3d_Device->SetTransform (D3DTS_VIEW, &matView);
    
	D3DXMatrixPerspectiveFovLH (&matProj, D3DX_PI/4, 1.0f, 1.0f, 10000.0f);
	p_d3d_Device->SetTransform (D3DTS_PROJECTION, &matProj);

	p_d3d_Device->SetRenderState (D3DRS_CULLMODE, D3DCULL_NONE);
	p_d3d_Device->SetRenderState (D3DRS_LIGHTING, TRUE);
	p_d3d_Device->SetRenderState (D3DRS_ZENABLE, D3DZB_TRUE);
	p_d3d_Device->SetRenderState (D3DRS_AMBIENT, 0);
}

void CMainWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	DestroyWindow();					//   
}

void CMainWnd::OnPaint()
{
    HRESULT hr;
	hr=p_d3d_Device->TestCooperativeLevel();
	if(hr==D3DERR_DEVICELOST) return;
	if (hr==D3DERR_DEVICENOTRESET)
	{
		p_d3d_Device->Reset(&d3dpp);
		Transform3D();
	}
	SetCursor(NULL);

	Transform3D();
	
	p_d3d_Device->Clear (0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
		D3DCOLOR_XRGB (128, 128, 0), 1.0f, 0);
    p_d3d_Device->BeginScene ();
	p_d3d_Device->SetVertexShader (D3DFVF_CUSTOMVERTEX);
	p_d3d_Device->SetStreamSource (0, p_VertexBuffer, sizeof(CUSTOMVERTEX));
	p_d3d_Device->DrawPrimitive (D3DPT_TRIANGLELIST, 0, 3);
   	p_d3d_Device->EndScene ();

    p_d3d_Device->Present (NULL, NULL, NULL, NULL);
}

class CMyApp : public CWinApp
{
public: 
	CMyApp();							//    
	virtual BOOL InitInstance();		//  
};

CMyApp::CMyApp()						//    
{

}

BOOL CMyApp::InitInstance()				//  
{ 
	m_pMainWnd=new CMainWnd();			//    
	ASSERT(m_pMainWnd);					//    
	m_pMainWnd->ShowWindow(SW_SHOW);	//   
	m_pMainWnd->UpdateWindow();			//   
	
	return TRUE;						//    
};

CMyApp theApp;							//  