// AllDialog.cpp : implementation file
//

#include "stdafx.h"
#include "TestDao3.h"
#include "AllDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAllDialog dialog


CAllDialog::CAllDialog(CWnd* pParent /*=NULL*/)
	: CDaoDialog(CAllDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAllDialog)
	m_pSet = NULL;
	//}}AFX_DATA_INIT
	m_pSet = new CAllSet();
	m_pSet->Open();
	SetRecordset(m_pSet);
	m_Book.SetRecordset(&cbookset);
	m_Piple.SetRecordset(&cpipleset); 
}


void CAllDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAllDialog)
	DDX_Control(pDX, IDC_COMBO_PIPLE, m_Piple);
	DDX_Control(pDX, IDC_COMBO_BOOK, m_Book);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAllDialog, CDialog)
	//{{AFX_MSG_MAP(CAllDialog)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_FIRST, OnButtonFirst)
	ON_BN_CLICKED(IDC_BUTTON_PREV, OnButtonPrev)
	ON_BN_CLICKED(IDC_BUTTON_NEXT, OnButtonNext)
	ON_BN_CLICKED(IDC_BUTTON_LAST, OnButtonLast)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAllDialog message handlers



void CAllDialog::OnDestroy() 
{
	CDialog::OnDestroy();
	delete m_pSet;	
}

void CAllDialog::UpdateCombo()
{
	m_Book.SetRecord(m_pSet->m_ID_BOOK);
	m_Piple.SetRecord(m_pSet->m_ID_PIPLE); 
}

BOOL CAllDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	//     
	m_Book.SetRecordset(&cbookset); 	
	m_Book.SetIndex("ID_BOOK");
	m_Book.SetFields("NAME_BOOK"); 
	m_Book.GetRecord(); 		

	m_Piple.SetRecordset(&cpipleset); 	
	m_Piple.SetFields("NAME_PIPLE");
	m_Piple.SetIndex("ID_PIPLE"); 
	m_Piple.GetRecord(); 

	UpdateCombo();	//  Combo
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAllDialog::OnSave()
{
m_pSet->m_ID_BOOK=m_Book.GetIndex();
m_pSet->m_ID_PIPLE =m_Piple.GetIndex();	
}

void CAllDialog::OnButtonFirst() 
{
First();
UpdateCombo();	
}

void CAllDialog::OnButtonPrev() 
{
Prev();
UpdateCombo();	
}

void CAllDialog::OnButtonNext() 
{
Next();
UpdateCombo();	
}

void CAllDialog::OnButtonLast() 
{
Last();
UpdateCombo();	
}
