// DialogAuthor.cpp : implementation file
//

#include "stdafx.h"
#include "Biblio.h"
#include "DialogAuthor.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialogAuthor dialog


CDialogAuthor::CDialogAuthor(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogAuthor::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogAuthor)
	m_pAuthor = NULL;
	//}}AFX_DATA_INIT
	m_pAuthor=new CAuthorSet(); 	
	m_pAuthor->Open();	
	
}


void CDialogAuthor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogAuthor)
	DDX_FieldText(pDX, IDC_EDIT1, m_pAuthor->m_column1, m_pAuthor);
	DDX_FieldText(pDX, IDC_EDIT2, m_pAuthor->m_column2, m_pAuthor);
	DDX_FieldText(pDX, IDC_EDIT3, m_pAuthor->m_column3, m_pAuthor);
	DDX_FieldText(pDX, IDC_EDIT4, m_pAuthor->m_column4, m_pAuthor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogAuthor, CDialog)
	//{{AFX_MSG_MAP(CDialogAuthor)
	ON_BN_CLICKED(IDC_BUTTON_NEXT, OnButtonNext)
	ON_BN_CLICKED(IDC_BUTTON_LAST, OnButtonLast)
	ON_BN_CLICKED(IDC_BUTTON_PREV, OnButtonPrev)
	ON_BN_CLICKED(IDC_BUTTON_FIRST, OnButtonFirst)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogAuthor message handlers


BOOL CDialogAuthor::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CDaoDatabase db;
	db.Open(DATABASENAME); //   DB
	CDaoTableDef cTable(&db);
    try
	{
	cTable.Open(TABLE_NAME_AUTHOR);	//	  
	}
	catch(...)
	{				//  	
		try	
		{
			cTable.Create(TABLE_NAME_AUTHOR); 	// 
			CDaoFieldInfo ci;
			cTable.CreateField("",dbLong,0,dbAutoIncrField); 
			cTable.CreateField("",dbText,255);
			cTable.CreateField("",dbText,255);
			cTable.CreateField("",dbMemo,0);
			cTable.Append(); 
		}
		catch(...)
		{
			return FALSE;
		}
	
	}
	cTable.Close();	//  
	db.Close();

	try
	{
		m_pAuthor->MoveFirst();		//   
	}
	catch(...)	//     
	{
		m_pAuthor->AddNew();
		m_pAuthor->Update();
		m_pAuthor->MoveFirst();		//    
		UpdateData(FALSE);			//     
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CDialogAuthor::DestroyWindow() 
{
	SaveData();
	m_pAuthor->Close();
	delete m_pAuthor;
	CDialog::DestroyWindow();
	return TRUE;
}



void CDialogAuthor::OnButtonNext() 
{
try
{
 SaveData();	 
 m_pAuthor->MoveNext();	//  
 if (m_pAuthor->IsEOF()) throw CString("");	//       
 UpdateData(FALSE);	   //    
}
catch(...)	//     
{
m_pAuthor->AddNew();
m_pAuthor->Update();
m_pAuthor->MoveLast(); //  
UpdateData(FALSE);	   //    
}
}

void CDialogAuthor::OnButtonLast() 
{
SaveData();
m_pAuthor->MoveLast(); //  
UpdateData(FALSE);	
}

void CDialogAuthor::OnButtonPrev() 
{
SaveData();
m_pAuthor->MovePrev();
if (m_pAuthor->IsBOF()) m_pAuthor->MoveNext();	//       
UpdateData(FALSE);	
}

void CDialogAuthor::OnButtonFirst() 
{
SaveData();
m_pAuthor->MoveFirst();  //  
UpdateData(FALSE);
}

void CDialogAuthor::SaveData()
{
m_pAuthor->Edit();			//  
UpdateData(TRUE);			//  
m_pAuthor->Update();		// 
}
