namespace Leo.LeonForm{

using System;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Net;
using Leon.RawThread;
using System.Threading;

internal class MainForm : Form
{
    ComboBox IPList = new ComboBox();
	Button BeginButton = new Button(), StopButton  = new Button();
    Thread Listener = null;
    RawWorker ClassWorker = new RawWorker();
    ListBox FromTo = new ListBox();
	internal MainForm():base()
	{
	 InitializeComponent();
	}

	private void InitializeComponent() 
	{
     StartPosition = FormStartPosition.CenterScreen;
	 IPList.DropDownStyle = ComboBoxStyle.DropDownList;
	 Controls.Add(IPList);
     // ip   
     IPHostEntry HosyEntry = Dns.Resolve(Dns.GetHostName());
	 if(HosyEntry.AddressList.Length > 0)
	 {
	  foreach(IPAddress ip in HosyEntry.AddressList)
	  {
	   //add ip to combobox
         IPList.Items.Add(ip.ToString());
	  }
	 }
     BeginButton.Text = "Start";
     BeginButton.Top = 25;
     BeginButton.Left = 0;
     BeginButton.Click += new EventHandler(BeginButton_Click); 
     Controls.Add(BeginButton);
     
     StopButton.Text = "Stop";
     StopButton.Top = 25;
     StopButton.Left = 80;
     StopButton.Click += new EventHandler(StopButton_Click); 
     Controls.Add(StopButton);

     FromTo.Top = 60;
     FromTo.Left = 0;
     FromTo.Size = new System.Drawing.Size(300, 150);
     FromTo.HorizontalScrollbar = true;
     FromTo.HorizontalExtent = 600;
     Controls.Add(FromTo);
     ClassWorker.RawForm = this; 
     Width += 50;
	}
    void BeginButton_Click(object sender, EventArgs e)
    {
     if(IPList.SelectedIndex < 0)
     {
      MessageBox.Show("You must select ip!");
      return;
     }
       AbortWork();
       ClassWorker.SelectedIP = IPList.SelectedItem.ToString();
       ClassWorker.ReceiveAll.Out = FromTo;
       Listener = new Thread(new ThreadStart(ClassWorker.Run));
       Listener.Start();
    }

    void StopButton_Click(object sender, EventArgs e)
    {
     AbortWork();
    }
    void AbortWork()
    {
     if(Listener != null)
     {    
       Listener.Abort();
       Listener.Join();
       Listener = null;
     }   
    }
    public override void Dispose()
    {
     AbortWork();
     base.Dispose();
    }

}

}